
/*  -*- pse-c -*-
 *----------------------------------------------------------------------------
 * Filename: iegd_interface_2615.c
 * $Revision: 1.9.2.1 $
 *----------------------------------------------------------------------------
 * Gart and DRM driver for Intel Embedded Graphics Driver
 * Copyright  2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/* Copyright 2003 - 2005 Intel Corporation. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *	Redistributions of source code must retain the above copyright notice,
 *      this list of conditions and the following disclaimer.
 *
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *
 *      Neither the name Intel Corporation nor the names of its contributors
 *      may be used to endorse or promote products derived from this software
 *      without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "iegd.h"
#include "drmP.h"
#include "drm.h"

#include "iegd_drm.h"

#include "iegd_drv.h"
#include "psb_intregs.h"
#include "intelpci.h"
#include <linux/i2c.h>

int drm_irq_install(drm_device_t *dev);

#if KERNEL2615
int intel_firstopen_2615(struct drm_device *dev)
{

	intel_device_private_t *priv;
	priv=(intel_device_private_t *)dev->dev_private;

	intel_postinit(&priv);
	dev->dev_private=priv;

	return 0;

}


int intel_psb_firstopen_2615(struct drm_device *dev)
{

	unsigned long resource_start;
	int rv;
	intel_device_private_t *priv;
	priv=(intel_device_private_t *)dev->dev_private;

	intel_postinit(&priv);
	psb_init(priv);
	dev->dev_private=priv;


	/*
	 * Map MMIO addresses so that the DRM can control interrupt support
	 */

	resource_start = pci_resource_start(dev->pdev, PSB_MMIO_RESOURCE);

	priv->vdc_reg = ioremap(resource_start + PSB_VDC_OFFSET, PSB_VDC_SIZE);

	if (!priv->vdc_reg) {
		/* Normally we'd want to unload the driver on failure.  But due
		 * to circular dependancies, we can only return failure.
		 */
		/* psb_driver_unload(dev); */
		return 1;
	}

	priv->sgx_reg = ioremap(resource_start + PSB_SGX_OFFSET, PSB_SGX_SIZE);
	if (!priv->sgx_reg) {
		/* Normally we'd want to unload the driver on failure.  But due
		 * to circular dependancies, we can only return failure.
		 */
		/* psb_driver_unload(dev); */
		return 1;
	}

	priv->msvdx_reg = ioremap(resource_start + PSB_MSVDX_OFFSET, PSB_MSVDX_SIZE);
	if (!priv->msvdx_reg) {
		/* Normally we'd want to unload the driver on failure.  But due
		 * to circular dependancies, we can only return failure.
		 */
		/* psb_driver_unload(dev); */
		return 1;
	}

	if (!dev->irq_enabled) {
		rv = drm_irq_install(dev);
		if (rv != 0) {
				DRM_ERROR("%s: could not install IRQs: rv = %d\n", __FUNCTION__, rv);
				return rv;
		}
	}

	return 0;

}

void intel_preclose_2615(drm_device_t *dev,DRMFILE filp)
{
	intel_prerelease(dev);
}


int intel_getpages_2615( struct inode *inode, struct file *filp,
	unsigned int cmd, unsigned long arg)
{
	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_getpages(dev,filp,arg);
}


int intel_freepages_2615( struct inode *inode, struct file *filp,
	unsigned int cmd, unsigned long arg )
{

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_freepages(dev,arg);
}


int intel_drm_info_init_2615( struct inode *inode, struct file *filp,
	unsigned int cmd, unsigned long arg )
{

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_drm_info_init(dev,arg);

}


int intel_drm_info_get_2615( struct inode *inode, struct file *filp,
	unsigned int cmd, unsigned long arg )
{

	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;
	return	intel_drm_info_get(dev,arg);

}


/* Following 2 functions were taken from drm_memory.c 
 * For some reason they are not being exported to use
 * by the other drm.
 */

/**
 * Allocate pages.
 *
 * \param order size order.
 * \param area memory area. (Not used.)
 * \return page address on success, or zero on failure.
 *
 * Allocate and reserve free pages.
 */
unsigned long intel_alloc_pages(int order, int area)
{
	unsigned long address;
	unsigned long bytes	  = PAGE_SIZE << order;
	unsigned long addr;
	unsigned int  sz;

	address = __get_free_pages(GFP_KERNEL, order);
	if (!address) 
		return 0;

				/* Zero */
	memset((void *)address, 0, bytes);

				/* Reserve */
	for (addr = address, sz = bytes;
	     sz > 0;
	     addr += PAGE_SIZE, sz -= PAGE_SIZE) {
		SetPageReserved(virt_to_page(addr));
	}

	return address;
}


/**
 * Free pages.
 * 
 * \param address address of the pages to free.
 * \param order size order.
 * \param area memory area. (Not used.)
 *
 * Unreserve and free pages allocated by alloc_pages().
 */
void intel_free_pages(unsigned long address, int order, int area)
{
	unsigned long bytes = PAGE_SIZE << order;
	unsigned long addr;
	unsigned int  sz;

	if (!address) {
		return;
	}

	/* Unreserve */
	for (addr = address, sz = bytes;
	     sz > 0;
	     addr += PAGE_SIZE, sz -= PAGE_SIZE) {
		ClearPageReserved(virt_to_page(addr));
	}

	free_pages(address, order);
}

static int psb_driver_load(struct drm_device *dev, unsigned long chipset)
{
	intel_device_private_t *priv;

	priv=(intel_device_private_t *)dev->dev_private;

	return 0;
}

int intel_drm_plb_interrupts_2615 ( struct inode *inode,
				struct file *filp,
				unsigned int cmd, void *arg )
{
	drm_file_t *priv=filp->private_data;
	drm_device_t *dev=priv->head->dev;

	return intel_drm_plb_interrupts( dev, arg );
}

drm_ioctl_desc_t intel_ioctls[] = {
	[DRM_IOCTL_NR(DRM_INTEL_GETPAGES)] = { intel_getpages_2615,  0},
	[DRM_IOCTL_NR(DRM_INTEL_FREEPAGES)] = { intel_freepages_2615, 0},
	[DRM_IOCTL_NR(DRM_INTEL_INFO_INIT)] = { intel_drm_info_init_2615, 0},
	[DRM_IOCTL_NR(DRM_INTEL_INFO_GET)] = { intel_drm_info_get_2615,  0},
	[DRM_IOCTL_NR(DRM_INTEL_INTERRUPT)] = {intel_drm_plb_interrupts_2615,0}
};

int intel_max_ioctl = DRM_ARRAY_SIZE(intel_ioctls);



static struct pci_device_id pciidlist[] = {
	INTEL_PCI_IDS
};

int device_is_agp_2615(drm_device_t * dev)
{
	return 1;
}


static struct drm_driver driver = {
	.firstopen = intel_firstopen_2615,
	.preclose = intel_preclose_2615,
	.reclaim_buffers=drm_core_reclaim_buffers,
	.get_map_ofs=drm_core_get_map_ofs,
	.get_reg_ofs=drm_core_get_reg_ofs,

	.device_is_agp = device_is_agp_2615,

	.major = DRIVER_MAJOR,
	.minor = DRIVER_MINOR,
	.patchlevel = DRIVER_PATCHLEVEL,
	.name = DRIVER_NAME,
	.desc = DRIVER_DESC,
	.date = DRIVER_DATE,

	.driver_features = DRIVER_USE_AGP|DRIVER_REQUIRE_AGP|DRIVER_USE_MTRR,
	.ioctls = intel_ioctls,
	.fops = {
		.owner = THIS_MODULE,
		.open = drm_open,
		.release = drm_release,
		.ioctl = drm_ioctl,
		.mmap = drm_mmap,
		.poll = drm_poll,
		.fasync = drm_fasync,
	},
	.pci_driver = {
		.name          = DRIVER_NAME,
		.id_table      = pciidlist,
	}
};

static struct drm_driver driver_plb = {
	.load = psb_driver_load,
	.firstopen = intel_psb_firstopen_2615,
	.preclose = intel_preclose_2615,
	.reclaim_buffers=drm_core_reclaim_buffers,
	.get_map_ofs=drm_core_get_map_ofs,
	.get_reg_ofs=drm_core_get_reg_ofs,

	.device_is_agp = device_is_agp_2615,

	.major = DRIVER_MAJOR,
	.minor = DRIVER_MINOR,
	.patchlevel = DRIVER_PATCHLEVEL,
	.name = DRIVER_NAME,
	.desc = DRIVER_DESC,
	.date = DRIVER_DATE,

	.driver_features = DRIVER_USE_AGP | DRIVER_REQUIRE_AGP |
		DRIVER_HAVE_IRQ | DRIVER_IRQ_SHARED,
	.ioctls = intel_ioctls,
	.irq_preinstall = psb_irq_preinstall,
	.irq_postinstall = psb_irq_postinstall,
	.irq_uninstall = psb_irq_uninstall,
	.irq_handler = psb_irq_handler,

	.fops = {
		.owner = THIS_MODULE,
		.open = drm_open,
		.release = drm_release,
		.ioctl = drm_ioctl,
		.mmap = drm_plb_mmap,
		.poll = drm_poll,
		.fasync = drm_fasync,
	},
	.pci_driver = {
		.name          = DRIVER_NAME,
		.id_table      = pciidlist,
	}
};


int intel_init(void)
{
	driver.num_ioctls = intel_max_ioctl;
	driver_plb.num_ioctls = intel_max_ioctl;

	/* We are peeking into the global AGP structures that
	 * we have access to in order to determine what chipset we're
	 * on.  This isn't necessarily a good thing to do.
	 */

	if (gart_id->device_id == PCI_DEVICE_ID_PLB) {
		printk(KERN_ERR "Initializing DRM for Intel US15 SCH\n");
		return drm_init(&driver_plb);
	} else {
		return drm_init(&driver);
	}

}

void intel_exit(void)
{
	drm_exit(&driver);
}

struct file_operations intel_buffer_fops = {
	.open	 = drm_open,
	.release = drm_release,
	.ioctl	 = drm_ioctl,
	.mmap	 = intel_mmap_buffers,
	.poll = drm_poll,
	.fasync  = drm_fasync,
};
#endif
