/*
 * APIs
 */
unsigned char getWtdTimer(void);

void setWtdTimer(unsigned char value);

int getInChLevel( int channel, unsigned char *val );

int setOutChLevel( int channel, unsigned char val );

int getOutChLevel( int channel, unsigned char *val );



/*
 * SuperIO Access Registers
 */
#define SIO_EFER  0x2e
#define SIO_EFIR  0x2e
#define SIO_EFDR  0x2f

/*
 * Chip Global Control Registers
 */
#define SIO_SFT_RST    0x02 // Software Reset
#define SIO_SEL_DEV    0x07 // Select Logic Device


/*
 * Config pin GP32, GP33, GP34 as GPIO.
 * Bit 7~5 at 0x2c:
 * 
 *  bit 7 = 1, GP34. bit 7 = 0, RSTOUT4#
 *  bit 6 = 1, GP33. bit 7 = 0, RSTOUT3#
 *  bit 5 = 1, GP32. bit 7 = 0, RSTOUT2#
 */
#define SIO_MFUNC_PIN_REG1 0x2c // Multi-Function Pin Selector register.
                                // Set up GPIO related bits.

#define SIO_MFUNC_PIN_REG2 0x2d // Multi-Function Pin Selector register.
                                // Set up Watchdog related bits.
/*
 * Logic Devices
 */
#define WTD_DEV      0x8  // Watchdog and PLED
#define GPIO_DEV     0x9  // GPIO 2,3,4,5
#define ACPI_DEV     0xa  // ACPI 

/*
 * GPIO
 */

/* Registers */
#define SIO_GPIO_ACT_REG   0x30 // Active Register
#define SIO_GPIO_STATUS    0xe7 // Status Register
#define SIO_GPIO_CONF      0xf0 // I/O Configuration Register
#define SIO_GPIO_DATA      0xf1 // Data Register
#define SIO_GPIO_IVRSN     0xf2 // Inversion Register
#define SIO_GPIO_MFUNC     0xf9 // Multi-function select Register
#define SIO_GPIO_ITYPE     0xfe // Input Detected Type Register  
#define SIO_ACPI_EVTROUT   0xfe // ACPI GP3 eventrout setting register

/* Configure GPIO */
#define SIO_GPIO_SET_IO    0xf0  // GP30~33: Output, GP34~37: Input
#define SIO_GPIO_EVTROUT   0x88  // Disable routing events from GP30,
                                 // GP31, GP35 to PSOUT# and PME#.

#define SIO_GPIO_ACT       0x02  // Active GPIO3

/* GPIO signal names */
#define GPO0     0x1 << 0
#define GPO1     0x1 << 1
#define GPO2     0x1 << 2
#define GPO3     0x1 << 3
#define GPOALL   0xf

#define GPI0     0x1 << 0
#define GPI1     0x1 << 1
#define GPI2     0x1 << 2
#define GPI3     0x1 << 3
#define GPIALL   0xf

/*
 * Watchdog
 */
/* Registers */
#define SIO_WTD_PINEAB       0xfe
#define SIO_WTD_ACT_REG      0x30
#define SIO_WTD_CONTROL      0xf5
#define SIO_WTD_COUNT        0xf6
#define SIO_WTD_STATUS       0xf7

/* Configure Watchdog */
#define SIO_WTD_ACTIVE       0x01
#define SIO_WTD_RESTO        0xef
#define SIO_WTD_SECOND       0xe7

