// AnalogDeviceAudioGraph.h: interface for the CAnalogDeviceAudioGraph class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANALOGDEVICEAUDIOGRAPH_H__61EACED7_0E49_424A_AAC0_241D12EF7791__INCLUDED_)
#define AFX_ANALOGDEVICEAUDIOGRAPH_H__61EACED7_0E49_424A_AAC0_241D12EF7791__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Graph.h"

class CAnalogDeviceAudioGraph : public CGraph  
{
public:

	CAnalogDeviceAudioGraph();

	virtual ~CAnalogDeviceAudioGraph();

public:

	// DEBUGGING FUNCTIONS
	//
	VOID					  SC_DEBUG( CHAR * fmt, ... );

	// MEMBER FUNCTIONS
	//
	BOOL					  Close( BOOL bDumpDebugMessage = TRUE );

	BOOL					  Create( PWSTR pwszDevName, UINT iDevNum, PF_BUFFER_CALLBACK pBufferCB, PVOID pUserData );

	BOOL					  GetFormat( ULONG * pChannels, ULONG * pBitsPerSample, ULONG * pSamplesPerSec );

	BOOL					  SetFormat( ULONG nChannels, ULONG nBitsPerSample, ULONG nSamplesPerSec );

	BOOL					  GetCustomProperty( ULONG nProperty, ULONG * pValue );
	
	BOOL					  SetCustomProperty( ULONG nProperty, ULONG nValue );

	// MEMBER VARIABLES
	// 
	IBaseFilter *             m_pCaptureSourceBaseFilter;

	IBaseFilter *             m_pSampleGrabberBaseFilter;

	IKsPropertySet *          m_pKsPropertySet;

	GUID					  m_sKsPropertySetGUID;

	IAMStreamConfig *		  m_pAMStreamConfig;

	CSampleGrabber			  m_oSampleGrabber;

	ISampleGrabber * 		  m_pSampleGrabber;

	ULONG					  m_nChannels;

	ULONG					  m_nBitsPerSample;

	ULONG					  m_nSamplesPerSec;
};

#endif // !defined(AFX_ANALOGDEVICEAUDIOGRAPH_H__61EACED7_0E49_424A_AAC0_241D12EF7791__INCLUDED_)
