// MultiRecoderDemoDlg.cpp : implementation file
//
#pragma once

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "MultiRecoderDemoDlg.h"

#include "LivePropertyDlg.h"

#include "ShareRecord.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#if __DEBUG

#pragma comment(linker, "/subsystem:console /entry:WinMainCRTStartup")

#endif

VOID Dbg( CHAR* lpc, ... )
{		
	char szData[ MAX_PATH ] = "[QC] ";

	va_list args;

	va_start( args, lpc );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, lpc, args );

	va_end( args ); 

	strcat( szData, "\n" ); 

	#if __DEBUG

	printf( szData );

	#else

	OutputDebugString( szData );

	#endif
}	


// INITIALIZE STATIC CLASS VARIABLE 
//
CMultiRecoderDemoDlg*	CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg = 0;

CRect					CMultiRecoderDemoDlg::s_rect_live_window_pos[ 4 ] = { 0 };

CRect					CMultiRecoderDemoDlg::s_rect_clone_window_pos[ 4 ] = { 0 };

CRect					CMultiRecoderDemoDlg::s_rect_share_window_pos = 0; 

//  FORMAT CHANGED CALLBACK FUNCTION
//
QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, ULONG nVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	Dbg("format changed Detected  \n");

	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	if ( m_pMainDlg == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDlg->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDlg->m_nVideoWidth[ nChannelNum ] = nVideoWidth;

	m_pMainDlg->m_nVideoHeight[ nChannelNum ] = nVideoHeight;

	m_pMainDlg->m_nVideoFrameRate[ nChannelNum ] = nVideoFrameRate;

	m_pMainDlg->m_bVideoIsInterleaved[ nChannelNum ] = bVideoIsInterleaved;

	m_pMainDlg->m_nAudioChannels[ nChannelNum ] = nAudioChannels;

	m_pMainDlg->m_nAudioBitsPerSample[ nChannelNum ] = nAudioBitsPerSample;

	m_pMainDlg->m_nAudioSampleFrequency[ nChannelNum ] = nAudioSampleFrequency;

	// OUTPUT FORMAT CHANGED MESSAGE
	//
	CHAR strVideoInput[ MAX_PATH ] = { 0 };

	CHAR strAudioInput[ MAX_PATH ] = { 0 };

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

    UINT nVH = 0;
            
    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); m_pMainDlg->m_strVideoInput = strVideoInput; }
 	
	if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); m_pMainDlg->m_strVideoInput = strVideoInput;}
	
	if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" ); m_pMainDlg->m_strVideoInput = strVideoInput;}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" ); m_pMainDlg->m_strVideoInput = strVideoInput;}
	
	if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" ); m_pMainDlg->m_strVideoInput = strVideoInput;}
	
	if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" ); m_pMainDlg->m_strVideoInput = strVideoInput;}
	
    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" ); m_pMainDlg->m_strVideoInput = strVideoInput;}
	
	if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" ); m_pMainDlg->m_strVideoInput = strVideoInput;}

	if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED" ); m_pMainDlg->m_strAudioInput = strAudioInput;}
	
	if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" ); m_pMainDlg->m_strAudioInput = strAudioInput;}

	nVH = nVideoHeight;

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, "i" ); } else { sprintf( strFrameType, "p" ); }

	
	// LIVE WINDOW INFO 
	//
	m_pMainDlg->m_strFormatChangedOutput[ nChannelNum ].Format( "%dx%d%s@%dfps,%s,\r\n%dch@%dbits,%dhz,%s",

													nVideoWidth,

													nVH,

													strFrameType,

													nVideoFrameRate,

													strVideoInput,

													nAudioChannels,

													nAudioBitsPerSample,

													nAudioSampleFrequency,
													
													strAudioInput ); 	

    // NO SOURCE
    //
    if ( nVideoWidth == 0 && 
		
		 nVideoHeight == 0 &&

		 nVideoFrameRate == 0 &&

		 nAudioChannels == 0 &&

		 nAudioBitsPerSample == 0 &&

		 nAudioSampleFrequency == 0 ) {

		m_pMainDlg->m_bNoSignal[ nChannelNum ] = TRUE;
	}
    else {

		m_pMainDlg->m_bNoSignal[ nChannelNum ] = FALSE;
    }

    return QCAP_RT_OK;
}    

// NO SIGNAL DETEACTED CALLBACK FUNCTION
//
QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	Dbg("No Signal Detected  \n");

	if ( m_pMainDlg == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDlg->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDlg->m_bNoSignal[ nChannelNum ] = TRUE;

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDlg->m_nVideoWidth[ nChannelNum ] = 0;

	m_pMainDlg->m_nVideoHeight[ nChannelNum ] = 0;

	return QCAP_RT_OK;
}

// SIGNAL REMOVED CALLBACK FUNCTION
//
QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;
	
	ULONG nChannelNum = (ULONG)pUserData;

	Dbg(" Signal Removed \n");

	if ( m_pMainDlg == NULL ) { return QCAP_RT_OK; }

	if ( m_pMainDlg->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	m_pMainDlg->m_bNoSignal[ nChannelNum ] = TRUE;

	// SAVE SHARE RECORDING INFO
	//
	m_pMainDlg->m_nVideoWidth[ nChannelNum ] = 0;

	m_pMainDlg->m_nVideoHeight[ nChannelNum ] = 0;

    return QCAP_RT_OK;
}

// PREVIEW VIDEO CALLBACK FUNCTION
//
QRETURN on_process_preview_video_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	ULONG nChannelNum = (ULONG)pUserData;

	if ( ( m_pMainDlg->m_bIsSetShareDisplayBuffer && m_pMainDlg->m_bShareRecordCH[ nChannelNum ]) ) {
	
		QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, MAKEFOURCC('Y', 'U', 'Y', '2'), m_pMainDlg->m_nVideoWidth[ nChannelNum ], m_pMainDlg->m_nVideoHeight[ nChannelNum ], pFrameBuffer, nFrameBufferLen );
	}

	if ( (m_pMainDlg->m_bIsSetShareRecordBuffer && m_pMainDlg->m_bShareRecordCH[ nChannelNum ]) ) {
	
		QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, MAKEFOURCC('Y', 'U', 'Y', '2'), m_pMainDlg->m_nVideoWidth[ nChannelNum ], m_pMainDlg->m_nVideoHeight[ nChannelNum ], pFrameBuffer, nFrameBufferLen );
	}

	if ( (m_pMainDlg->m_bIsSetShareStreammingBuffer && m_pMainDlg->m_bShareRecordCH[ nChannelNum ]) ) {

		QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( m_pMainDlg->m_hStreamServer,
														0,
														MAKEFOURCC('Y', 'U', 'Y', '2'),
														m_pMainDlg->m_nVideoWidth[ nChannelNum ],
														m_pMainDlg->m_nVideoHeight[ nChannelNum ],
														pFrameBuffer,
														//NULL,
														nFrameBufferLen );
	}

    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	ULONG nChannelNum = (ULONG)pUserData;

	if ( (m_pMainDlg->m_bIsShareRecord && m_pMainDlg->m_bShareRecordCH[ nChannelNum ]) || m_pMainDlg->m_bIsShareDisplay && (m_pMainDlg->m_bShareRecordCH[ nChannelNum ]) ) {

		QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
	}

	if ( (m_pMainDlg->m_bIsSetShareStreammingBuffer && m_pMainDlg->m_bShareRecordCH[ nChannelNum ]) ) {
	
		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( m_pMainDlg->m_hStreamServer,
														0,
														pFrameBuffer,
														nFrameBufferLen );		
	}

	return QCAP_RT_OK;
	//return QCAP_RT_FAIL;
}

// SHARE STREAMMING VIDEO CALLBACK FUNCTION
//
QRETURN on_process_share_streamming_video_buffer( UINT iRecNum, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, BOOL bIsKeyframe ,PVOID pUserData)
{
	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	ULONG nChannelNum = (ULONG)pUserData;

    return QCAP_RT_OK;
}

// SHARE STREAMMING AUDIO CALLBACK FUNCTION
//
QRETURN on_process_share_streamming_audio_buffer( UINT iRecNum, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	ULONG nChannelNum = (ULONG)pUserData;

	return QCAP_RT_OK;
}
/////////////////////////////////////////////////////////////////////////////
// CMultiRecoderDemoDlg dialog

CMultiRecoderDemoDlg::CMultiRecoderDemoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMultiRecoderDemoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMultiRecoderDemoDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON);
}

void CMultiRecoderDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMultiRecoderDemoDlg)
	DDX_Control(pDX, IDC_BUTTON_SHARE_STREAMMING, m_btnStreamming);
	DDX_Control(pDX, IDC_EDIT_LIVE_INFO4, m_editLiveInfo04);
	DDX_Control(pDX, IDC_EDIT_LIVE_INFO3, m_editLiveInfo03);
	DDX_Control(pDX, IDC_EDIT_LIVE_INFO2, m_editLiveInfo02);
	DDX_Control(pDX, IDC_EDIT_LIVE_INFO1, m_editLiveInfo01);
	DDX_Control(pDX, IDC_EDIT_SHARE_INFO, m_editShareRecordInfo);
	DDX_Control(pDX, IDC_BUTTON_SHARE_RECORD, m_btnShareRecord);
	DDX_Control(pDX, IDC_BTN_PROPERTY_4, m_btnProperty_4);
	DDX_Control(pDX, IDC_BTN_RECORD_4, m_btnRecord_4);
	DDX_Control(pDX, IDC_BTN_RECORD_3, m_btnRecord_3);
	DDX_Control(pDX, IDC_BTN_RECORD_2, m_btnRecord_2);
	DDX_Control(pDX, IDC_BTN_RECORD_1, m_btnRecord_1);
	DDX_Control(pDX, IDC_BTN_PROPERTY_3, m_btnProperty_3);
	DDX_Control(pDX, IDC_BTN_PROPERTY_2, m_btnProperty_2);
	DDX_Control(pDX, IDC_BTN_PROPERTY_1, m_btnProperty_1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMultiRecoderDemoDlg, CDialog)
	//{{AFX_MSG_MAP(CMultiRecoderDemoDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BTN_RECORD_1, OnBtnRecord_Ch1_1)
	ON_BN_CLICKED(IDC_BTN_RECORD_2, OnBtnRecord_Ch2_1)
	ON_BN_CLICKED(IDC_BTN_RECORD_3, OnBtnRecord_Ch3_1)
	ON_BN_CLICKED(IDC_BTN_RECORD_4, OnBtnRecord_Ch4_1)
	ON_WM_DESTROY()
	ON_WM_LBUTTONDOWN()
	ON_BN_CLICKED(IDC_BUTTON_SHARE_RECORD, OnButtonShareRecord)
	ON_BN_CLICKED(IDC_BTN_PROPERTY_1, OnBtnLiveProperty1)
	ON_BN_CLICKED(IDC_BTN_PROPERTY_2, OnBtnLiveProperty2)
	ON_BN_CLICKED(IDC_BTN_PROPERTY_3, OnBtnLiveProperty3)
	ON_BN_CLICKED(IDC_BTN_PROPERTY_4, OnBtnLiveProperty4)
	ON_BN_CLICKED(IDC_BTN_SNAPSHOT1, OnBtnSnapshot1)
	ON_BN_CLICKED(IDC_BTN_SNAPSHOT2, OnBtnSnapshot2)
	ON_BN_CLICKED(IDC_BTN_SNAPSHOT3, OnBtnSnapshot3)
	ON_BN_CLICKED(IDC_BTN_SNAPSHOT4, OnBtnSnapshot4)
	ON_BN_CLICKED(IDC_BUTTON_SHARE_PROPERTY, OnButtonShareProperty)
	ON_BN_CLICKED(IDC_CHECK_SHARE_DIASPLAY, OnCheckShareDiasplay)
	ON_BN_CLICKED(IDC_BUTTON_SHARE_STREAMMING, OnButtonShareStreamming)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMultiRecoderDemoDlg message handlers

BOOL CMultiRecoderDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg = this;

	// INITIALIZE MEMBER VARIABLES
	//
	m_bShareSupportGPU1_1		= FALSE;

	m_bSupportGPU1_1			= FALSE	;
	
	m_bIsRecord1_1				= FALSE;

	m_bSupportGPU1_2			= FALSE;
	
	m_bIsRecord1_2				= FALSE;
	
	m_bSupportGPU2_1			= FALSE;
	
	m_bIsRecord2_1				= FALSE;

	m_bSupportGPU2_2			= FALSE;
	
	m_bIsRecord2_2				= FALSE;

	m_bSupportGPU3_1			= FALSE;
	
	m_bIsRecord3_1				= FALSE;

	m_bSupportGPU3_2			= FALSE;
	
	m_bIsRecord3_2				= FALSE;

	m_bSupportGPU4_1			= FALSE;
	
	m_bIsRecord4_1				= FALSE;

	m_bSupportGPU4_2			= FALSE;
	
	m_bIsRecord4_2				= FALSE;
		
	m_nCurSelectChannelNumber	= -1;

	m_nAudioPlayChannel			= -1;

	m_nWndState					= 0;			// 0 = SPLIT, 1 = FULL SCREEN

	m_bIsShareRecord			= FALSE;

	m_nLivePropertyNumber		= -1;


	// GET DEFAULT RECORD PATH
	// 
	BYTE pData[ MAX_PATH ]; DWORD dwType = REG_SZ; DWORD dwData = MAX_PATH;

	HKEY hKey = NULL; RegOpenKey( HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &hKey );

	RegQueryValueEx( hKey, "Personal", NULL, &dwType, pData, &dwData );

	RegCloseKey( hKey );

	CHAR psz[ MAX_PATH ] = "";

	if ( strlen( (CHAR*)(pData) ) ) {

		m_strDefaultPath[ 0 ].Format( "%s", (CHAR*)(pData) );

		m_strDefaultPath[ 1 ].Format( "%s", (CHAR*)(pData) );

		m_strDefaultPath[ 2 ].Format( "%s", (CHAR*)(pData) );

		m_strDefaultPath[ 3 ].Format( "%s", (CHAR*)(pData) );
	}
	else {

		m_strDefaultPath[ 0 ].Format( "%s", "" );

		m_strDefaultPath[ 1 ].Format( "%s", "" );

		m_strDefaultPath[ 2 ].Format( "%s", "" );

		m_strDefaultPath[ 3 ].Format( "%s", "" );
	}

	
	m_strSnapshotPath[ 0 ].Format( "%s\\My Snapshots", m_strDefaultPath );

	m_strRecordPath[ 0 ].Format( "%s\\My Records", m_strDefaultPath );

	CreateDirectory( m_strSnapshotPath[ 0 ], NULL );

	CreateDirectory( m_strRecordPath[ 0 ], NULL );

	{	// SET PAHT
		::GetModuleFileName( 0, m_strSnapshotPath[ 0 ].GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );
			
		m_strSnapshotPath[ 0 ].ReleaseBuffer();

		INT nPos;

		nPos = m_strSnapshotPath[ 0 ].ReverseFind('\\');
			
		// GET PATH
		m_strSnapshotPath[ 0 ] = m_strSnapshotPath[ 0 ].Left( nPos );

		m_strSnapshotPath[ 1 ] = m_strSnapshotPath[ 0 ].Left( nPos );

		m_strSnapshotPath[ 2 ] = m_strSnapshotPath[ 0 ].Left( nPos );

		m_strSnapshotPath[ 3 ] = m_strSnapshotPath[ 0 ].Left( nPos );


		m_strRecordPath[ 0 ] = m_strSnapshotPath[ 0 ].Left( nPos );

		m_strRecordPath[ 1 ] = m_strSnapshotPath[ 0 ].Left( nPos );

		m_strRecordPath[ 2 ] = m_strSnapshotPath[ 0 ].Left( nPos );

		m_strRecordPath[ 3 ] = m_strSnapshotPath[ 0 ].Left( nPos );


		m_strShareRecordPath = m_strSnapshotPath[ 0 ].Left( nPos );


		
		CString strFullPath;
			
		//m_strRecordPath = m_pMainDialog->m_strSnapshotPath;

		ULONG nStrlen = strFullPath.GetLength();

		CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

		strFullPath.ReleaseBuffer();
	}

	// 0x00000000 BMP, 0x00000001 JPG
	//
	m_nSnapshotType[ 0 ] = 0x00000000;

	m_nSnapshotType[ 1 ] = 0x00000000;

	m_nSnapshotType[ 2 ] = 0x00000000;

	m_nSnapshotType[ 3 ] = 0x00000000;


	// DEVICE PARAM
	//
	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {
		
		m_hVideoDevice[ i ]				= 0;

		m_hCloneCapDev[ i ]				= 0;

		m_hCloneOSDCapDev[ i ]			= 0;

		//m_oCloneOSDWindows[ i ]			= 0;

		m_nVideoWidth[ i ]				= 0;

		m_nVideoHeight[ i ]				= 0;

		m_bVideoIsInterleaved[ i ]		= FALSE;

		m_nVideoFrameRate[ i ]			= 0;

		// AUDIO INPUT PROPERTY
		//
		m_nAudioInput[ i ]				= 0;

		m_nAudioChannels[ i ]			= 0;

		m_nAudioBitsPerSample[ i ]		= 0;

		m_nAudioSampleFrequency[ i ]	= 0;
			
		m_bNoSignal[ i ]				= TRUE;

		m_bShareRecordCH[ i ]			= FALSE;

		m_nLiveTabPage[ i ]				= 0x00000002;

		m_nAudioVolume[ i ]				= 0x00000000;

		// VIDEO INPUT PROPERTY
		//
		m_nSharpness[ i ]				= 128;

		m_nSaturation[ i ]				= 128;

		m_nHue[ i ]						= 128;

		m_nConstrast[ i ]				= 128;

		m_nBrightness[ i ]				= 128;

		// RECORD PARAM
		//
		m_nRecordFormat[ i ]			= 0x00000001;

		m_nRecordStandard[ i ]			= 0x00000000;

		m_nRecordResolutionPos[ i ]		= 0x00000000;

		m_nRecordFrameRatePos[ i ]		= 0x00000000;

		m_nRecordAudioFormat[ i ]		= 0x00000000;

		m_nRecordGOP[ i ]				= 0x0000001D;

		m_nRecordMode[ i ]				= 0x00000001;

		m_nRecordBiteRate[ i ]			= 0x00000002;

		m_nRecordQuality[ i ]			= 0x00000000;

		m_nRecordScale[ i ]				= 0x00000000;

		m_bRecordSupportGPU[ i ]		= TRUE;

		m_bRecordAutoDeinterlace[ i ]	= FALSE;

		// SNAPSHOT PARAM
		//
		m_nSnapshotType[ i ]			= 0x00000000;

		m_nSnapshotSyncDuration[ i ]	= 0x00000000;

		m_nContinueSnapshotNum[ i ]		= 0x00000000;
	} 

	// DEFAULT SHARE RECORD CHANNEL
	//
	m_bShareRecordCH[ 0 ]				= TRUE;

	m_nShareDisplayChannelNumber		= 0;				// DEFAULT 0 CH	

	m_nShareRecordStandard				= 0x00000000;

	m_nShareRecordResolutionPos			= 0x00000001;

	m_nShareRecordFrameRatePos			= 0x00000000;

	m_nShareRecordFormat				= 0x00000001;

	m_nShareRecordAudioFormat			= 0x00000001;

	m_nShareRecordGOP					= 0x0000001D;

	m_nShareRecordMode					= 0x00000001;

	m_nShareRecordBiteRate				= 0x00000002;

	m_nShareRecordQuality				= 0x00000000;

	m_nShareRecordScale					= 0x00000000;

	m_bShareRecordSupportGPU			= TRUE;

	m_bShareRecordAutoDeinterlace		= FALSE;

	m_bIsShareDisplay					= TRUE;

	m_bIsSetShareDisplayBuffer			= FALSE;

	m_bIsSetShareRecordBuffer			= FALSE;
	
	((CButton*)GetDlgItem( IDC_CHECK_SHARE_DIASPLAY ))->SetCheck( m_bIsShareDisplay );
	((CButton*)GetDlgItem( IDC_CHECK_SHARE_DIASPLAY ))->ShowWindow( FALSE );

	// SETTING STREAMMING SERVER
	//
	m_hStreamServer						= NULL;

	// SETTING SHARE WINDOW INFO (DEFAULT)
	//
	m_strShareFormatChangedOutput.Format( "CH%02d:%dx%d@%d FPS, %dCH@%dBits x %dHz",
											1,
											1920,
											1080,
											60,
											2,
											16,
											48000 ); 

	// DEFAULT SHARE STREAMMING PARAM
	//
	m_bIsSetShareStreammingBuffer = FALSE;

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );	

	//
	// INITIALIZE USER INTERFACE RESOURCE
	//	
	
	// INITIALIZE MAIN WINDOW
	//
	CRect oWindowRect; GetWindowRect( &oWindowRect );

	CRect oClientRect; GetClientRect( &oClientRect );

	ULONG cx = oWindowRect.Width() - oClientRect.Width();																			// GET DEFAULT BOUNDARY WIDTH OF DIALOG

	ULONG cy = oWindowRect.Height() - oClientRect.Height();																			// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

	ULONG nSharePropertyPadding = 20;

	ULONG nLivePropertyPadding = 96;	// with live info

	MoveWindow( 0, 0, cx + DEFAULT_NORMAL_WIDTH, cy + DEFAULT_NORMAL_HEIGHT + nSharePropertyPadding + nLivePropertyPadding );		// CREATE AND MAINTIN LAYOUT

	SetWindowPos( &CWnd::wndTop, 0, 0, 0, 0, SWP_NOSIZE );																			// SET THE LOCATION OF MAIN DIALOG

	
	// CREATE SHARE VIDEO WINDOW
	//	
	CHAR szStr[ MAX_PATH ] = { 0 };

	CMultiRecoderDemoDlg::s_rect_share_window_pos = CRect( 0, 0, DEFAULT_NORMAL_WIDTH, (DEFAULT_NORMAL_WIDTH / 16) * 9 );

	m_oShareWindows.Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect( 0, 0, 0, 0 ), this, 0x30000000, NULL );													// SHARE WINDOW
			
	m_oShareWindows.MoveWindow( CMultiRecoderDemoDlg::s_rect_share_window_pos );

	m_oShareWindows_BK.Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, CRect( 0, 0, 0, 0 ), this, 0x30000001, NULL );												// SHARE WINDOW
			
	m_oShareWindows_BK.MoveWindow( CMultiRecoderDemoDlg::s_rect_share_window_pos );

	m_oShareWindows.ShowWindow( TRUE );
	
	m_oShareWindows_BK.ShowWindow( FALSE );

	// MOVE PROPERTY, RECORD AND INFO BAR OF THE SHARE WINDOW
	//
	ULONG n_btn_share_property_left			= 0;

	ULONG n_btn_share_property_top			= CMultiRecoderDemoDlg::s_rect_share_window_pos.Height() + 3;		

	ULONG n_btn_share_property_width		= (((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2);

	ULONG n_btn_share_property_height		= 25;

	ULONG n_btn_share_property_left_padding = 32;
	
	CRect rc_btn_share_property( n_btn_share_property_left, n_btn_share_property_top , n_btn_share_property_left, n_btn_share_property_height );

	rc_btn_share_property = CRect( 	DEFAULT_NORMAL_WIDTH - n_btn_share_property_width * 2 - 1,			//	
			
									n_btn_share_property_top,
			
									n_btn_share_property_width,
			
									n_btn_share_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BUTTON_SHARE_PROPERTY ), rc_btn_share_property.left, rc_btn_share_property.top, rc_btn_share_property.right, rc_btn_share_property.bottom, TRUE );

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	ULONG n_btn_share_record_left	= 0;

	ULONG n_btn_share_record_top	= n_btn_share_property_top;		

	ULONG n_btn_share_record_width	= n_btn_share_property_width;

	ULONG n_btn_share_record_height = n_btn_share_property_height;
	
	CRect rc_btn_share_record( n_btn_share_property_left, n_btn_share_property_top , n_btn_share_property_left, n_btn_share_property_height ) ;

	rc_btn_share_record = CRect( 	DEFAULT_NORMAL_WIDTH - n_btn_share_property_width * 1 - 1,
			
									n_btn_share_record_top,
			
									n_btn_share_record_width,
			
									n_btn_share_record_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BUTTON_SHARE_RECORD ), rc_btn_share_record.left, rc_btn_share_record.top, rc_btn_share_record.right, rc_btn_share_record.bottom, TRUE );
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// SHARE INFO (EDIT)
	//
	ULONG n_share_edit_left		= 0;

	ULONG n_share_edit_top		= CMultiRecoderDemoDlg::s_rect_share_window_pos.Height() + 3;	

	ULONG n_share_edit_width	= DEFAULT_NORMAL_WIDTH - n_btn_share_property_width * 2 - ( n_btn_share_record_width + 20 );

	ULONG n_share_edit_height	= n_btn_share_property_height;
	
	CRect rc_share_edit( n_share_edit_left, n_share_edit_top, n_share_edit_left, n_share_edit_height );


	rc_share_edit = CRect(	n_share_edit_left,
			
							n_share_edit_top,
			
							n_share_edit_width,
			
							n_share_edit_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_SHARE_INFO + 0 ), rc_share_edit.left, rc_share_edit.top, rc_share_edit.right, rc_share_edit.bottom, TRUE );

	::SetWindowText( ::GetDlgItem( m_hWnd, IDC_EDIT_SHARE_INFO + 0 ), "INFO:" );
	
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// SHARE STREAMMING (BUTTON)
	//
	ULONG n_btn_share_streamming_left		= n_share_edit_width;

	ULONG n_btn_share_streamming_top		= CMultiRecoderDemoDlg::s_rect_share_window_pos.Height() + 3;	

	ULONG n_btn_share_streamming_width		= n_btn_share_property_width + 20;

	ULONG n_btn_share_streamming_height		= n_btn_share_property_height;
	
	CRect rc_btn_share_streamming( n_btn_share_streamming_left, n_btn_share_streamming_top, n_btn_share_streamming_left, n_btn_share_streamming_height );


	rc_btn_share_streamming = CRect(	n_btn_share_streamming_left,
			
										n_btn_share_streamming_top,
			
										n_btn_share_streamming_width,
			
										n_btn_share_streamming_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BUTTON_SHARE_STREAMMING + 0 ), rc_btn_share_streamming.left, rc_btn_share_streamming.top, rc_btn_share_streamming.right, rc_btn_share_streamming.bottom, TRUE );

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// CREATE LIVE VIDEO WINDOW
	//	
	ULONG rc_wnd_left = 0;

	ULONG rc_wnd_top = CMultiRecoderDemoDlg::s_rect_share_window_pos.Height() + 10 + nSharePropertyPadding;	

	ULONG rc_wnd_width = (CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10;

	ULONG rc_wnd_height = (CMultiRecoderDemoDlg::s_rect_share_window_pos.Height() / 4) - 5;
	
	CRect rc_wnd( rc_wnd_left, rc_wnd_top , rc_wnd_left, rc_wnd_top + rc_wnd_height );

	ULONG padding = 12;

	for ( i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ )	{
		
		rc_wnd = CRect( (rc_wnd_width * i) + (padding * i),
			
					rc_wnd.top,
			
					rc_wnd_width * (i + 1) + (padding * i),
			
					rc_wnd.bottom );
	
		CMultiRecoderDemoDlg::s_rect_live_window_pos[ i ] = rc_wnd;

		wsprintf( szStr, "MyChannelWindowLIVE#%02d", i + 1 );

		m_oChannelWindows_LIVE[ i ].Create(	NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, CMultiRecoderDemoDlg::s_rect_live_window_pos[ i ], this, i + 0x00000000, NULL );		// VIDEO WINDOW
		
				
		wsprintf( szStr, "MyChannelWindowBK#%02d", i + 1 );

		m_oChannelWindows_BK[ i ].Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, CMultiRecoderDemoDlg::s_rect_live_window_pos[ i ], this, i + 0x10000000, NULL );			// BACKGROUND WINDOW


		m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

		m_oChannelWindows_BK[ i ].ShowWindow( TRUE );

	}

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//	LIVE INFO (EDIT)
	//
	ULONG rc_edit_left = 0;

	ULONG rc_edit_top = rc_wnd_top + rc_wnd_height + 5;	

	ULONG rc_edit_width = (CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10;

	ULONG rc_edit_height = 36;
	
	CRect rc_edit( rc_edit_left, rc_edit_top , rc_edit_left, rc_edit_height );


	rc_edit = CRect( (	rc_edit_width * 0) + (padding * 0),
			
							rc_edit_top,
			
							rc_edit_width,
			
							rc_edit.bottom );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 0 ), rc_edit.left, rc_edit.top, rc_edit.right, rc_edit.bottom, TRUE );

	::SetWindowText( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 0 ), "INFO:" );


	rc_edit = CRect( (	rc_edit_width * 1) + (padding * 1),
			
							rc_edit_top,
			
							rc_edit_width,
			
							rc_edit.bottom );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 1 ), rc_edit.left, rc_edit.top, rc_edit.right, rc_edit.bottom, TRUE );

	::SetWindowText( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 1 ), "INFO:" );


	rc_edit = CRect( (	rc_edit_width * 2) + (padding * 2),
			
							rc_edit_top,
			
							rc_edit_width,
			
							rc_edit.bottom );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 2 ), rc_edit.left, rc_edit.top, rc_edit.right, rc_edit.bottom, TRUE );

	::SetWindowText( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 2 ), "INFO:" );



	rc_edit = CRect( (	rc_edit_width * 3) + (padding * 3),
			
							rc_edit_top,
			
							rc_edit_width,
			
							rc_edit.bottom );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 3 ), rc_edit.left, rc_edit.top, rc_edit.right, rc_edit.bottom, TRUE );

	::SetWindowText( ::GetDlgItem( m_hWnd, IDC_EDIT_LIVE_INFO1 + 3 ), "INFO:" );

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	// LIVE PROPERTY (BUTTON)
	//
	ULONG rc_btn_property_left = 0;

	ULONG rc_btn_property_top = rc_edit_top + rc_edit_height + 5;	

	ULONG rc_btn_property_width = (((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2) / 2 ;

	ULONG rc_btn_property_height = 25;
	
	CRect rc_btn_property( rc_btn_property_left, rc_btn_property_top, rc_btn_property_left, rc_btn_property_height );

	rc_btn_property = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 0) + (padding * 0),
			
								rc_btn_property_top,
			
								rc_btn_property_width,
			
								rc_btn_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_PROPERTY_1 ), rc_btn_property.left, rc_btn_property.top, rc_btn_property.right, rc_btn_property.bottom, TRUE );


	rc_btn_property = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 1) + (padding * 1),
			
								rc_btn_property_top,
			
								rc_btn_property_width,
			
								rc_btn_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_PROPERTY_2 ), rc_btn_property.left, rc_btn_property.top, rc_btn_property.right, rc_btn_property.bottom, TRUE );


	rc_btn_property = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 2) + (padding * 2),
			
								rc_btn_property_top,
			
								rc_btn_property_width,
			
								rc_btn_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_PROPERTY_3 ), rc_btn_property.left, rc_btn_property.top, rc_btn_property.right, rc_btn_property.bottom, TRUE );


	rc_btn_property = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 3) + (padding * 3),
			
								rc_btn_property_top,
			
								rc_btn_property_width,
			
								rc_btn_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_PROPERTY_4 ), rc_btn_property.left, rc_btn_property.top, rc_btn_property.right, rc_btn_property.bottom, TRUE );

	// LIVE SNAPSHOT (BUTTON)
	//
	ULONG rc_btn_snapshot_left = 0;

	ULONG rc_btn_snapshot_top = rc_edit_top + rc_edit_height + 5;	

	ULONG rc_btn_snapshot_width = (((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2) / 2 ;

	ULONG rc_btn_snapshot_height = 25;

	ULONG rc_btn_snapshot_padding = (((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2) / 2;
	
	CRect rc_btn_snapshot( rc_btn_snapshot_left, rc_btn_snapshot_top, rc_btn_snapshot_left, rc_btn_snapshot_height );

	rc_btn_snapshot = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 0) + (padding * 0) + rc_btn_snapshot_padding,
			
								rc_btn_snapshot_top,
			
								rc_btn_snapshot_width,
			
								rc_btn_snapshot_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_SNAPSHOT1 ), rc_btn_snapshot.left, rc_btn_snapshot.top, rc_btn_snapshot.right, rc_btn_snapshot.bottom, TRUE );


	rc_btn_snapshot = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 1) + (padding * 1) + rc_btn_snapshot_padding,
			
								rc_btn_property_top,
			
								rc_btn_property_width,
			
								rc_btn_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_SNAPSHOT2 ), rc_btn_snapshot.left, rc_btn_snapshot.top, rc_btn_snapshot.right, rc_btn_snapshot.bottom, TRUE );


	rc_btn_snapshot = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 2) + (padding * 2) + rc_btn_snapshot_padding,
			
								rc_btn_property_top,
			
								rc_btn_property_width,
			
								rc_btn_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_SNAPSHOT3 ), rc_btn_snapshot.left, rc_btn_snapshot.top, rc_btn_snapshot.right, rc_btn_snapshot.bottom, TRUE );


	rc_btn_snapshot = CRect( (	((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 3) + (padding * 3) + rc_btn_snapshot_padding,
			
								rc_btn_property_top,
			
								rc_btn_property_width,
			
								rc_btn_property_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_SNAPSHOT4 ), rc_btn_snapshot.left, rc_btn_snapshot.top, rc_btn_snapshot.right, rc_btn_snapshot.bottom, TRUE );

	// LIVE RECORD (BUTTON)
	//
	ULONG rc_btn_record_left = 0;

	ULONG rc_btn_record_top = rc_edit_top + rc_edit_height + 5;	

	ULONG rc_btn_record_width = (((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2);

	ULONG rc_btn_record_height = 25;
	
	CRect rc_btn_record( rc_btn_record_left, rc_btn_record_top , rc_btn_record_left, rc_btn_record_height );

	rc_btn_record = CRect( (	(((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2) + 3 + ((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 0) + (padding * 0),		
			
								rc_btn_record_top,
			
								rc_btn_record_width,
			
								rc_btn_record_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_RECORD_1 ), rc_btn_record.left, rc_btn_record.top, rc_btn_record.right, rc_btn_record.bottom, TRUE );

	rc_btn_record = CRect( (	(((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2) + 3 + ((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 1) + (padding * 1),
			
								rc_btn_record_top,
			
								rc_btn_record_width,
			
								rc_btn_record_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_RECORD_2 ), rc_btn_record.left, rc_btn_record.top, rc_btn_record.right, rc_btn_record.bottom, TRUE );


	rc_btn_record = CRect( (	(((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2) + 3 + ((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 2) + (padding * 2),

			
								rc_btn_record_top,
			
								rc_btn_record_width,
			
								rc_btn_record_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_RECORD_3 ), rc_btn_record.left, rc_btn_record.top, rc_btn_record.right, rc_btn_record.bottom, TRUE );


	rc_btn_record = CRect( (	(((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) / 2) + 3 + ((CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() / 4) - 10) * 3) + (padding * 3),
			
								rc_btn_record_top,
			
								rc_btn_record_width,
			
								rc_btn_record_height );

	::MoveWindow( ::GetDlgItem( m_hWnd, IDC_BTN_RECORD_4 ), rc_btn_record.left, rc_btn_record.top, rc_btn_record.right, rc_btn_record.bottom, TRUE );

	// INITILIZE INI FILE
	//
	//m_strIniDes = GetAppPath() + "Profile.ini";

	//Dbg( "%s\n",m_strIniDes.GetBuffer( MAX_PATH ) );

	//{
		// CREATE A INI FILE

	//	BYTE nSetIniFileFlag = SetIniFile(  m_strIniDes.GetBuffer( MAX_PATH ) );		

	//	if ( nSetIniFileFlag == INI_RS_ERROR_FILE_NOT_EXIST  ) {
		
	//		BOOL bSetProfileData = SetProfileData( m_strIniDes );			
	//	}
	//	else if( nSetIniFileFlag == INI_RS_ERROR_FILE_EXIST  ) {
		
	//		BOOL bGetProfileData = GetProfileData( m_strIniDes );
	//	}
//	}

	//m_strIniDes.ReleaseBuffer();

	// INITILIZE DEVICE RESOURCE
	//
	HwInitialize();	

	{
		CHAR sz[ MAX_PATH ] = { 0 };

		wsprintf( sz, "%s ,  %s  CH%02d V", DEFAULT_PRODUCT, DEFAULT_PRODUCT_VERSION,  1 );

		SetWindowText( sz );
	}
	
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMultiRecoderDemoDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CMultiRecoderDemoDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


BOOL CMultiRecoderDemoDlg::HwInitialize()
{
	// CALLBACK FUNCTION
	//        
	PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB[ 4 ] = { 0 };

	PF_VIDEO_PREVIEW_CALLBACK  m_pPreviewVideoCB[ 4 ] = { 0 };

	PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB[ 4 ] = { 0 };
   
	PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB[ 4 ] = { 0 };

	PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB[ 4 ] = { 0 };

	// SHARE STREAMMING FUNCTION
	//
	PF_VIDEO_SHARE_RECORD_CALLBACK m_pShareStreammingVideoCB = 0;

	PF_AUDIO_SHARE_RECORD_CALLBACK m_pShareStreammingAudioCB = 0;

	// REGISTER PREVIEW VIDEO CALLBACK FUNCTION
	// 
	m_pShareStreammingVideoCB = on_process_share_streamming_video_buffer;

	QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK( 0, m_pShareStreammingVideoCB, (PVOID)this );

	// REGISTER PREVIEW AUDIO CALLBACK FUNCTION
	//
	m_pShareStreammingAudioCB = on_process_share_streamming_audio_buffer;

	QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK( 0, m_pShareStreammingAudioCB, (PVOID)this );


	BOOL bIsDeviceRun = FALSE;

	for ( ULONG i = 0; i < 4; i++ ) {

		// CREATE CAPTURE DEVICE
		//
		QCAP_CREATE( "SA7160 PCI", i, m_oChannelWindows_LIVE[ i ].m_hWnd, &m_hVideoDevice[ i ], TRUE );
		
		if ( m_hVideoDevice[ i ] == 0 ) { continue; }

		bIsDeviceRun = TRUE;

		// REGISTER FORMAT CHANGED CALLBACK FUNCTION
		// 
		m_pFormatChangedCB[ i ] = on_process_format_changed;

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], m_pFormatChangedCB[ i ], (PVOID)i );

		// REGISTER PREVIEW VIDEO CALLBACK FUNCTION
		// 
		m_pPreviewVideoCB[ i ] = on_process_preview_video_buffer;

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewVideoCB[ i ], (PVOID)i );

		// REGISTER PREVIEW AUDIO CALLBACK FUNCTION
		//
		m_pPreviewAudioCB[ i ] = on_process_preview_audio_buffer;

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewAudioCB[ i ], (PVOID)i );
		
		// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
		//
		m_pNoSignalDetectedCB[ i ] = on_process_no_signal_detected;

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], m_pNoSignalDetectedCB[ i ], (PVOID)i );

		// REGISTER SIGNAL REMOVED CALLBACK FUNCTION
		//
		m_pSignalRemovedCB[ i ] =  on_process_signal_removed;

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], m_pSignalRemovedCB[ i ], (PVOID)i );

		QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 0 );

		QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

		//QCAP_SET_VIDEO_INPUT( m_hVideoDevice[ i ], 0x00000006 );	// SDI

		QCAP_RUN( m_hVideoDevice[ i ] );
	}
  
	SetTimer( 0x00000001, 1000, NULL );

	SetTimer( 0x00000002, 200, NULL );

	// AUTO CHECK SIGNAL
	//
	for ( i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {
		
		if ( !m_bNoSignal[ i ]  ) {
			
			m_bShareRecordCH[ i ] = TRUE;

			m_nShareDisplayChannelNumber = i;

			break;
		}
	}

	SetShareFormatChangedOutput_CShareRecord();

	// PREVIEW SHARE DISPLAY
	//
	CString strFullPath, strFileResolutionName, strFileQualityName, strFileLastName;

	QCAP_STOP_SHARE_RECORD( 0 );
		
	// SET SHARE RECORD PROPERTY FOR AUDIO
	//
	ULONG nAudioFormat = ( m_nShareRecordFormat == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;		
	
	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, nAudioFormat, 2, 16, 48000, 100 );

	// SET SHARE RECORD PROPERTY FOR VIDEO
	//
	ULONG nShareRecordMode = ( m_nShareRecordMode == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

	ULONG nShareRecordVideoWidth = 1920;

	ULONG nShareRecordVideoHeight = 1080;

	if ( m_nShareRecordStandard == 0 ) {														// NTSC
		
		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 720 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 480 ; 
	}
	else {

		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 576 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 576 ;		
	}

	ULONG nShareRecordQuality = ( m_nShareRecordQuality == 0 ) ? 10000 : 
								( m_nShareRecordQuality == 1 ) ? 9500 :
								( m_nShareRecordQuality == 2 ) ? 9000 :
								( m_nShareRecordQuality == 3 ) ? 8500 :
								( m_nShareRecordQuality == 4 ) ? 8000 :
								( m_nShareRecordQuality == 5 ) ? 7500 :
								( m_nShareRecordQuality == 6 ) ? 7000 :
								( m_nShareRecordQuality == 7 ) ? 6500 :
								( m_nShareRecordQuality == 8 ) ? 6000 :
								( m_nShareRecordQuality == 9 ) ? 5500 :
								( m_nShareRecordQuality == 10 ) ? 5000 :
								( m_nShareRecordQuality == 11 ) ? 4500 :
								( m_nShareRecordQuality == 12 ) ? 4000 :
								( m_nShareRecordQuality == 13 ) ? 3500 :
								( m_nShareRecordQuality == 14 ) ? 3000 :
								( m_nShareRecordQuality == 15 ) ? 2500 :
								( m_nShareRecordQuality == 16 ) ? 2000 :
								( m_nShareRecordQuality == 17 ) ? 1500 :
								( m_nShareRecordQuality == 18 ) ? 1000 :
								( m_nShareRecordQuality == 19 ) ? 500 : 0;

	ULONG	nShareRecordBiteRate = ( m_nShareRecordBiteRate == 0 ) ? 12 * 1024 * 1024 : 
								   ( m_nShareRecordBiteRate == 1 ) ? 10 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 2 ) ? 8 * 1024 * 1024 :
							       ( m_nShareRecordBiteRate == 3 ) ? 6 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 4 ) ? 4 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 5 ) ? 3 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 6 ) ? 2 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 7 ) ? 1 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 8 ) ? 768 * 1024 :
								   ( m_nShareRecordBiteRate == 9 ) ? 512 * 1024 : 256 * 1024 ;
	
	ULONG	nShareRecordScale = ( m_nShareRecordScale == 0 ) ? QCAP_DOWNSCALE_MODE_OFF : 
							    ( m_nShareRecordScale == 1 ) ? QCAP_DOWNSCALE_MODE_2_3 :
							    ( m_nShareRecordScale == 2 ) ? QCAP_DOWNSCALE_MODE_1_2 : QCAP_DOWNSCALE_MODE_1_4;

	ULONG	bShareRecordSupportGPU = ( m_bShareRecordSupportGPU ) ? QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK : QCAP_ENCODER_TYPE_SOFTWARE ;

	
	// 2012.12.26 custom setting
	if ( m_bIsShareDisplay ) {
		
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nShareRecordVideoWidth, nShareRecordVideoHeight, 30, nShareRecordMode, nShareRecordQuality, nShareRecordBiteRate, 30, 0, 0, m_oShareWindows.m_hWnd, TRUE );
	}
	else {
		
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nShareRecordVideoWidth, nShareRecordVideoHeight, 30, nShareRecordMode, nShareRecordQuality, nShareRecordBiteRate, 30, 0, 0, NULL, TRUE );
	}

	QCAP_START_SHARE_RECORD( 0, NULL, 0x00000004);

	m_bIsSetShareDisplayBuffer = TRUE;

	return TRUE;
}

BOOL CMultiRecoderDemoDlg::HwUninitialize()
{	
	if ( m_hStreamServer ) {

		QCAP_STOP_BROADCAST_SERVER( m_hStreamServer );
		
		QCAP_DESTROY_BROADCAST_SERVER( m_hStreamServer );	
	}

	for ( ULONG i = 0; i < 4; i++ ) {		

		// CLOSE SHARE VIDEO RECORD
		//
		if ( m_bIsShareRecord != 0 || m_bIsShareDisplay) {

			QCAP_STOP_SHARE_RECORD( 0 );
		}
		
		// CLOSE LIVE VIDEO RECORD
		//
		if ( i == 0 ) {

			if ( m_bIsRecord1_1 && m_bNoSignal[ i ] ) {

				QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );
			}
		}

		if ( i == 1 ) {

			if ( m_bIsRecord2_1 && m_bNoSignal[ i ] ) {

				QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );		
			}
		}

		if ( i == 2 ) {

			if ( m_bIsRecord3_1 && m_bNoSignal[ i ] ) {

				QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );	
			}
		}

		if ( i == 3 ) {

			if ( m_bIsRecord4_1 && m_bNoSignal[ i ] ) {

				QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );
			}
		}	

		// CLOSE LIVE VIDEO DEVICE
		//
		if ( m_hVideoDevice[ i ] != 0 ) {

			QCAP_STOP( m_hVideoDevice[ i ] );

			QCAP_DESTROY( m_hVideoDevice[ i ] );

			m_hVideoDevice[ i ] = 0;
		}
	}

	return TRUE;
}

BOOL CMultiRecoderDemoDlg::OnLButtonDblClk_ChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point ) {

	m_nCurSelectChannelNumber = nChannelNum;
	
	CHAR szStr[ MAX_PATH ] = { 0 };	
		
	if ( m_nWndState ) {		// FULL TO SPLIT SCREEN

		for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {


			if ( i == nChannelNum ) {

				m_oChannelWindows_LIVE[ i ].MoveWindow( CMultiRecoderDemoDlg::s_rect_live_window_pos[ i ] );

				m_oChannelWindows_BK[ i ].MoveWindow( CMultiRecoderDemoDlg::s_rect_live_window_pos[ i ] );

				QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

				m_nAudioPlayChannel = -1;

				wsprintf( szStr, "%s ,  %s  CH%02d V", DEFAULT_PRODUCT, DEFAULT_PRODUCT_VERSION,  i + 1 );

				SetWindowText( szStr );
			}
			else {

				m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

				m_oChannelWindows_BK[ i ].ShowWindow( FALSE );

				if ( m_bNoSignal[ i ] ) { 
					
					m_oShareWindows.ShowWindow( FALSE );
				}
				else {
				
					m_oShareWindows.ShowWindow( TRUE );
				}

				m_oShareWindows_BK.ShowWindow( FALSE );
			}
		}
		
		GetDlgItem( IDC_EDIT_SHARE_INFO )->ShowWindow( TRUE );

		GetDlgItem( IDC_BUTTON_SHARE_PROPERTY )->ShowWindow( TRUE );

		GetDlgItem( IDC_BUTTON_SHARE_RECORD )->ShowWindow( TRUE );		
			
		m_nWndState = 0;
	}		
	else {		//  SPLIT TO FULL SCREEN
			
		CRect oWindowRect; GetWindowRect( &oWindowRect );

		CRect oClientRect; GetClientRect( &oClientRect );

		ULONG cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

		ULONG cy = oWindowRect.Height() - oClientRect.Height();		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

		CRect rect( 0 , 0 ,
			CMultiRecoderDemoDlg::s_rect_share_window_pos.Width() ,
			CMultiRecoderDemoDlg::s_rect_share_window_pos.bottom + (CMultiRecoderDemoDlg::s_rect_live_window_pos[ nChannelNum ].bottom - CMultiRecoderDemoDlg::s_rect_live_window_pos[ nChannelNum ].top)  );

		for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {

			if ( i ==  nChannelNum ) {

				m_oChannelWindows_LIVE[ i ].MoveWindow( rect );
					
				m_oChannelWindows_BK[ i ].MoveWindow( rect );

				QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 100 );
					
				m_nAudioPlayChannel = i;

				wsprintf( szStr, "%s ,  %s  CH%02d A/V", DEFAULT_PRODUCT, DEFAULT_PRODUCT_VERSION,  i + 1 );

				SetWindowText( szStr );
			}
			else {

				m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

				m_oChannelWindows_BK[ i ].ShowWindow( FALSE );

				m_oShareWindows.ShowWindow( FALSE );
				
				m_oShareWindows_BK.ShowWindow( FALSE );
			}
		}

		GetDlgItem( IDC_EDIT_SHARE_INFO )->ShowWindow( FALSE );

		GetDlgItem( IDC_BUTTON_SHARE_PROPERTY )->ShowWindow( FALSE );

		GetDlgItem( IDC_BUTTON_SHARE_RECORD )->ShowWindow( FALSE );
			
		m_nWndState = 1;
	} 

	return TRUE;

}

void CMultiRecoderDemoDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default

	if ( nIDEvent == 0x00000001 ) {	
		
		for ( ULONG i = 0; i < 4; i++ ) {
			
			if ( m_hVideoDevice[ i ] == NULL ) { continue ; }

			else {
			
				if ( i == 0 ) {

					if ( m_bIsRecord1_1 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord1_1 = false;
					}
				}

				if ( i == 1 ) {

					if ( m_bIsRecord2_1 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord2_1 = false;
					}
				}

				if ( i == 2 ) {

					if ( m_bIsRecord3_1 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord3_1 = false;
					}
				}

				if ( i == 3 ) {

					if ( m_bIsRecord4_1 && m_bNoSignal[ i ] ) {

						QCAP_STOP_RECORD( m_hVideoDevice[ i ], 0 );

						m_bIsRecord4_1 = false;
					}
				}
			}			
		}
	}

	// TO CONTROL WHETHER THE SIGNAL OF EACH CHNNAEL IS OR ISN'T
	//
	if( nIDEvent == 0x00000002 ) {		

		for ( ULONG i = 0; i < 4; i++ ) {
			
			if ( !m_nWndState ) { 

				if ( m_bNoSignal[ i ] ) {				

					if ( i == 0 ) { m_editLiveInfo01.SetWindowText( _T("...") ); }

					if ( i == 1 ) { m_editLiveInfo02.SetWindowText( _T("...") ); }

					if ( i == 2 ) { m_editLiveInfo03.SetWindowText( _T("...") ); }

					if ( i == 3 ) { m_editLiveInfo04.SetWindowText( _T("...") ); }						

					m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

					m_oChannelWindows_BK[ i ].ShowWindow( TRUE );
				}
				else {

					// 2013.01.08 @ WHEN SC510 IS NOT SUPPORT 1080P
					//
					if ( m_nVideoWidth[ i ] == 1920 &&
									 
				 		 m_bVideoIsInterleaved[ i ] == 0 &&
									
						 m_nVideoFrameRate[ i ] != 24 &&
									
						 m_nVideoFrameRate[ i ] != 30 ) {
									
						 m_oChannelWindows_LIVE[ i ].ShowWindow( FALSE );

						 m_oChannelWindows_BK[ i ].ShowWindow( TRUE );	
					}
					else {
							
						 m_oChannelWindows_LIVE[ i ].ShowWindow( TRUE );

						 m_oChannelWindows_BK[ i ].ShowWindow( FALSE );	
					}

					if ( i == 0 ) { 
							
						m_editLiveInfo01.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 0 ] );						
					}

					if ( i == 1 ) {
							
						m_editLiveInfo02.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 1 ] );			
					}

					if ( i == 2 ) {
						
						m_editLiveInfo03.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 2 ] );					
					}

					if ( i == 3 ) {
							
						m_editLiveInfo04.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 3 ] );
					}

					// SHARE WINDOW INFO
					//					
					if ( i == m_nShareDisplayChannelNumber ) {

						if ( m_bNoSignal[ i ] ) {							
					
							m_editShareRecordInfo.SetWindowText( (LPCTSTR)m_strShareFormatChangedOutput );	

							m_oShareWindows.ShowWindow( FALSE );
			
							m_oShareWindows_BK.ShowWindow( TRUE );
						}
						else {

							m_editShareRecordInfo.SetWindowText( (LPCTSTR)m_strShareFormatChangedOutput );	
							
							m_oShareWindows.ShowWindow( TRUE );
			
							m_oShareWindows_BK.ShowWindow( FALSE );
						}
					}
				}
			}
		}		
	}

	
	CDialog::OnTimer(nIDEvent);
}

void CMultiRecoderDemoDlg::OnBtnRecord_Ch1_1() 
{
	// TODO: Add your control notification handler code here

	if ( m_bNoSignal[ 0 ] ) { return; }

	if ( m_hVideoDevice[ 0 ] != 0 ) {

		CString strFullPath, strFileResolutionName, strFileQualityName, strFileLastName;

		if ( m_bIsRecord1_1 == 0  ) {

			ULONG nAudioFormat = ( m_nRecordFormat[ 0 ] == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;	
			
			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice[ 0 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, nAudioFormat );

			ULONG nRecordMode = ( m_nRecordMode[ 0 ] == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

			ULONG nRecordQuality = ( m_nRecordQuality[ 0 ] == 0 ) ? 10000 : 
								   ( m_nRecordQuality[ 0 ] == 1 ) ? 9500 :
								   ( m_nRecordQuality[ 0 ] == 2 ) ? 9000 :
								   ( m_nRecordQuality[ 0 ] == 3 ) ? 8500 :
								   ( m_nRecordQuality[ 0 ] == 4 ) ? 8000 :
								   ( m_nRecordQuality[ 0 ] == 5 ) ? 7500 :
								   ( m_nRecordQuality[ 0 ] == 6 ) ? 7000 :
								   ( m_nRecordQuality[ 0 ] == 7 ) ? 6500 :
								   ( m_nRecordQuality[ 0 ] == 8 ) ? 6000 :
								   ( m_nRecordQuality[ 0 ] == 9 ) ? 5500 :
								   ( m_nRecordQuality[ 0 ] == 10 ) ? 5000 :
								   ( m_nRecordQuality[ 0 ] == 11 ) ? 4500 :
								   ( m_nRecordQuality[ 0 ] == 12 ) ? 4000 :
								   ( m_nRecordQuality[ 0 ] == 13 ) ? 3500 :
								   ( m_nRecordQuality[ 0 ] == 14 ) ? 3000 :
								   ( m_nRecordQuality[ 0 ] == 15 ) ? 2500 :
								   ( m_nRecordQuality[ 0 ] == 16 ) ? 2000 :
								   ( m_nRecordQuality[ 0 ] == 17 ) ? 1500 :
								   ( m_nRecordQuality[ 0 ] == 18 ) ? 1000 :
								   ( m_nRecordQuality[ 0 ] == 19 ) ? 500 : 0;

			ULONG	nRecordBiteRate = ( m_nRecordBiteRate[ 0 ] == 0 ) ? 12 * 1024 * 1024 : 
								   ( m_nRecordBiteRate[ 0 ] == 1 ) ? 10 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 2 ) ? 8 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 3 ) ? 6 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 4 ) ? 4 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 5 ) ? 3 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 6 ) ? 2 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 7 ) ? 1 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 8 ) ? 768 * 1024 :
								   ( m_nRecordBiteRate[ 0 ] == 9 ) ? 512 * 1024 : 256 * 1024 ;

			ULONG	nRecordScale = ( m_nRecordScale[ 0 ] == 0 ) ? QCAP_DOWNSCALE_MODE_OFF : 
								   ( m_nRecordScale[ 0 ] == 1 ) ? QCAP_DOWNSCALE_MODE_2_3 :
								   ( m_nRecordScale[ 0 ] == 2 ) ? QCAP_DOWNSCALE_MODE_1_2 : QCAP_DOWNSCALE_MODE_1_4;

			ULONG bRecordSupportGPU = ( m_bRecordSupportGPU[ 0 ] ) ? QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK : QCAP_ENCODER_TYPE_SOFTWARE ;

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice[ 0 ], 0, bRecordSupportGPU, QCAP_ENCODER_FORMAT_H264, nRecordMode, nRecordQuality, nRecordBiteRate, 30, 0, 0, nRecordScale );

			if ( nAudioFormat == 0 ) { strFileLastName = _T(".avi"); }
			else { strFileLastName = _T(".mp4"); }

			strFileResolutionName = "unname1";

			if ( m_nRecordBiteRate[ 0 ] == 0 ) { strFileQualityName.Format( _T("_%dM"), 12 ); }

			if ( m_nRecordBiteRate[ 0 ] == 1 ) { strFileQualityName.Format( _T("_%dM"), 10 ); }

			if ( m_nRecordBiteRate[ 0 ] == 2 ) { strFileQualityName.Format( _T("_%dM"), 8 ); }

			if ( m_nRecordBiteRate[ 0 ] == 3 ) { strFileQualityName.Format( _T("_%dM"), 6 ); }

			if ( m_nRecordBiteRate[ 0 ] == 4 ) { strFileQualityName.Format( _T("_%dM"), 4 ); }

			if ( m_nRecordBiteRate[ 0 ] == 5 ) { strFileQualityName.Format( _T("_%dM"), 3 ); }	

			if ( m_nRecordBiteRate[ 0 ] == 6 ) { strFileQualityName.Format( _T("_%dM"), 2 ); }
			
			if ( m_nRecordBiteRate[ 0 ] == 7 ) { strFileQualityName.Format( _T("_%dM"), 1 ); }

			if ( m_nRecordBiteRate[ 0 ] == 8 ) { strFileQualityName.Format( _T("_%dK"), 768 ); }

			if ( m_nRecordBiteRate[ 0 ] == 9 ) { strFileQualityName.Format( _T("_%dK"), 512 ); }			

			strFullPath = m_strRecordPath[ 0 ] + strFileResolutionName + strFileQualityName + strFileLastName;

			ULONG nStrlen = strFullPath.GetLength();

			CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );			

			QCAP_START_RECORD( m_hVideoDevice[ 0 ], 0, psz );

			m_bIsRecord1_1 = true;

			strFullPath.ReleaseBuffer();

			m_btnRecord_1.SetWindowText( "Stop Record" );			
		}
		else {

			QCAP_STOP_RECORD( m_hVideoDevice[ 0 ], 0, TRUE, 0 );

			m_bIsRecord1_1 = false;

			m_btnRecord_1.SetWindowText( "Start Record" );			
		}
	}	
}

void CMultiRecoderDemoDlg::OnBtnRecord_Ch2_1() 
{
	// TODO: Add your control notification handler code here

	if ( m_bNoSignal[ 1 ] ) { return; }

	if ( m_hVideoDevice[ 1 ] != 0 ) {

		CString strFullPath, strFileResolutionName, strFileQualityName, strFileLastName;

		if ( m_bIsRecord2_1 == 0  ) {

			ULONG nAudioFormat = ( m_nRecordFormat[ 1 ] == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;	

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice[ 1 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, nAudioFormat );

			ULONG nRecordMode = ( m_nRecordMode[ 1 ] == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

			ULONG nRecordQuality = ( m_nRecordQuality[ 1 ] == 0 ) ? 10000 : 
								   ( m_nRecordQuality[ 1 ] == 1 ) ? 9500 :
								   ( m_nRecordQuality[ 1 ] == 2 ) ? 9000 :
								   ( m_nRecordQuality[ 1 ] == 3 ) ? 8500 :
								   ( m_nRecordQuality[ 1 ] == 4 ) ? 8000 :
								   ( m_nRecordQuality[ 1 ] == 5 ) ? 7500 :
								   ( m_nRecordQuality[ 1 ] == 6 ) ? 7000 :
								   ( m_nRecordQuality[ 1 ] == 7 ) ? 6500 :
								   ( m_nRecordQuality[ 1 ] == 8 ) ? 6000 :
								   ( m_nRecordQuality[ 1 ] == 9 ) ? 5500 :
								   ( m_nRecordQuality[ 1 ] == 10 ) ? 5000 :
								   ( m_nRecordQuality[ 1 ] == 11 ) ? 4500 :
								   ( m_nRecordQuality[ 1 ] == 12 ) ? 4000 :
								   ( m_nRecordQuality[ 1 ] == 13 ) ? 3500 :
								   ( m_nRecordQuality[ 1 ] == 14 ) ? 3000 :
								   ( m_nRecordQuality[ 1 ] == 15 ) ? 2500 :
								   ( m_nRecordQuality[ 1 ] == 16 ) ? 2000 :
								   ( m_nRecordQuality[ 1 ] == 17 ) ? 1500 :
								   ( m_nRecordQuality[ 1 ] == 18 ) ? 1000 :
								   ( m_nRecordQuality[ 1 ] == 19 ) ? 500 : 0;

			ULONG	nRecordBiteRate = ( m_nRecordBiteRate[ 1 ] == 0 ) ? 12 * 1024 * 1024 : 
								   ( m_nRecordBiteRate[ 1 ] == 1 ) ? 10 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 2 ) ? 8 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 3 ) ? 6 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 4 ) ? 4 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 5 ) ? 3 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 6 ) ? 2 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 7 ) ? 1 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 8 ) ? 768 * 1024 :
								   ( m_nRecordBiteRate[ 1 ] == 9 ) ? 512 * 1024 : 256 * 1024 ;

			ULONG	nRecordScale = ( m_nRecordScale[ 1 ] == 0 ) ? QCAP_DOWNSCALE_MODE_OFF : 
								   ( m_nRecordScale[ 1 ] == 1 ) ? QCAP_DOWNSCALE_MODE_2_3 :
								   ( m_nRecordScale[ 1 ] == 2 ) ? QCAP_DOWNSCALE_MODE_1_2 : QCAP_DOWNSCALE_MODE_1_4;

			ULONG bRecordSupportGPU = ( m_bRecordSupportGPU[ 1 ] ) ? QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK : QCAP_ENCODER_TYPE_SOFTWARE ;
	
			QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice[ 1 ], 0, bRecordSupportGPU, QCAP_ENCODER_FORMAT_H264, nRecordMode, nRecordQuality, nRecordBiteRate, 30, 0, 0, nRecordScale );

			if ( nAudioFormat == 0 ) { strFileLastName = _T(".avi"); }
			else { strFileLastName = _T(".mp4"); }


			strFileResolutionName = "unname2";

			if ( m_nRecordBiteRate[ 1 ] == 0 ) { strFileQualityName.Format( _T("_%dM"), 12 ); }

			if ( m_nRecordBiteRate[ 1 ] == 1 ) { strFileQualityName.Format( _T("_%dM"), 10 ); }

			if ( m_nRecordBiteRate[ 1 ] == 2 ) { strFileQualityName.Format( _T("_%dM"), 8 ); }

			if ( m_nRecordBiteRate[ 1 ] == 3 ) { strFileQualityName.Format( _T("_%dM"), 6 ); }

			if ( m_nRecordBiteRate[ 1 ] == 4 ) { strFileQualityName.Format( _T("_%dM"), 4 ); }

			if ( m_nRecordBiteRate[ 1 ] == 5 ) { strFileQualityName.Format( _T("_%dM"), 3 ); }	

			if ( m_nRecordBiteRate[ 1 ] == 6 ) { strFileQualityName.Format( _T("_%dM"), 2 ); }
			
			if ( m_nRecordBiteRate[ 1 ] == 7 ) { strFileQualityName.Format( _T("_%dM"), 1 ); }

			if ( m_nRecordBiteRate[ 1 ] == 8 ) { strFileQualityName.Format( _T("_%dK"), 768 ); }

			if ( m_nRecordBiteRate[ 1 ] == 9 ) { strFileQualityName.Format( _T("_%dK"), 512 ); }			

			strFullPath = m_strRecordPath[ 1 ] + strFileResolutionName + strFileQualityName + strFileLastName;

			ULONG nStrlen = strFullPath.GetLength();

			CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );			

			QCAP_START_RECORD( m_hVideoDevice[ 1 ], 0, psz );


			m_bIsRecord2_1 = true;

			strFullPath.ReleaseBuffer();

			m_btnRecord_2.SetWindowText( "Stop Record" );			
		}
		else {			

			QCAP_STOP_RECORD( m_hVideoDevice[ 1 ], 0, TRUE, 0 );

			m_bIsRecord2_1 = false;

			m_btnRecord_2.SetWindowText( "Start Record" );
		}
	}		
}

void CMultiRecoderDemoDlg::OnBtnRecord_Ch3_1() 
{
	// TODO: Add your control notification handler code here

	if ( m_bNoSignal[ 2 ] ) { return; }

	if ( m_hVideoDevice[ 2 ] != 0 ) {

		CString strFullPath, strFileResolutionName, strFileQualityName, strFileLastName;

		if ( m_bIsRecord3_1 == 0  ) {

			ULONG nAudioFormat = ( m_nRecordFormat[ 2 ] == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;	

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice[ 2 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, nAudioFormat );

			ULONG nRecordMode = ( m_nRecordMode[ 2 ] == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

			ULONG nRecordQuality = ( m_nRecordQuality[ 2 ] == 0 ) ? 10000 : 
								   ( m_nRecordQuality[ 2 ] == 1 ) ? 9500 :
								   ( m_nRecordQuality[ 2 ] == 2 ) ? 9000 :
								   ( m_nRecordQuality[ 2 ] == 3 ) ? 8500 :
								   ( m_nRecordQuality[ 2 ] == 4 ) ? 8000 :
								   ( m_nRecordQuality[ 2 ] == 5 ) ? 7500 :
								   ( m_nRecordQuality[ 2 ] == 6 ) ? 7000 :
								   ( m_nRecordQuality[ 2 ] == 7 ) ? 6500 :
								   ( m_nRecordQuality[ 2 ] == 8 ) ? 6000 :
								   ( m_nRecordQuality[ 2 ] == 9 ) ? 5500 :
								   ( m_nRecordQuality[ 2 ] == 10 ) ? 5000 :
								   ( m_nRecordQuality[ 2 ] == 11 ) ? 4500 :
								   ( m_nRecordQuality[ 2 ] == 12 ) ? 4000 :
								   ( m_nRecordQuality[ 2 ] == 13 ) ? 3500 :
								   ( m_nRecordQuality[ 2 ] == 14 ) ? 3000 :
								   ( m_nRecordQuality[ 2 ] == 15 ) ? 2500 :
								   ( m_nRecordQuality[ 2 ] == 16 ) ? 2000 :
								   ( m_nRecordQuality[ 2 ] == 17 ) ? 1500 :
								   ( m_nRecordQuality[ 2 ] == 18 ) ? 1000 :
								   ( m_nRecordQuality[ 2 ] == 19 ) ? 500 : 0;

			ULONG	nRecordBiteRate = ( m_nRecordBiteRate[ 2 ] == 0 ) ? 12 * 1024 * 1024 : 
								   ( m_nRecordBiteRate[ 2 ] == 1 ) ? 10 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 2 ) ? 8 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 3 ) ? 6 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 4 ) ? 4 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 5 ) ? 3 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 6 ) ? 2 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 7 ) ? 1 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 8 ) ? 768 * 1024 :
								   ( m_nRecordBiteRate[ 2 ] == 9 ) ? 512 * 1024 : 256 * 1024 ;

			ULONG	nRecordScale = ( m_nRecordScale[ 2 ] == 0 ) ? QCAP_DOWNSCALE_MODE_OFF : 
								   ( m_nRecordScale[ 2 ] == 1 ) ? QCAP_DOWNSCALE_MODE_2_3 :
								   ( m_nRecordScale[ 2 ] == 2 ) ? QCAP_DOWNSCALE_MODE_1_2 : QCAP_DOWNSCALE_MODE_1_4;

			ULONG bRecordSupportGPU = ( m_bRecordSupportGPU[ 2 ] ) ? QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK : QCAP_ENCODER_TYPE_SOFTWARE ;

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice[ 2 ], 0, bRecordSupportGPU, QCAP_ENCODER_FORMAT_H264, nRecordMode, nRecordQuality, nRecordBiteRate, 30, 0, 0, nRecordScale );

			if ( nAudioFormat == 0 ) { strFileLastName = _T(".avi"); }
			else { strFileLastName = _T(".mp4"); }
		
			strFileResolutionName = "unname3";

			if ( m_nRecordBiteRate[ 2 ] == 0 ) { strFileQualityName.Format( _T("_%dM"), 12 ); }

			if ( m_nRecordBiteRate[ 2 ] == 1 ) { strFileQualityName.Format( _T("_%dM"), 10 ); }

			if ( m_nRecordBiteRate[ 2 ] == 2 ) { strFileQualityName.Format( _T("_%dM"), 8 ); }

			if ( m_nRecordBiteRate[ 2 ] == 3 ) { strFileQualityName.Format( _T("_%dM"), 6 ); }

			if ( m_nRecordBiteRate[ 2 ] == 4 ) { strFileQualityName.Format( _T("_%dM"), 4 ); }

			if ( m_nRecordBiteRate[ 2 ] == 5 ) { strFileQualityName.Format( _T("_%dM"), 3 ); }	

			if ( m_nRecordBiteRate[ 2 ] == 6 ) { strFileQualityName.Format( _T("_%dM"), 2 ); }
			
			if ( m_nRecordBiteRate[ 2 ] == 7 ) { strFileQualityName.Format( _T("_%dM"), 1 ); }

			if ( m_nRecordBiteRate[ 2 ] == 8 ) { strFileQualityName.Format( _T("_%dK"), 768 ); }

			if ( m_nRecordBiteRate[ 2 ] == 9 ) { strFileQualityName.Format( _T("_%dK"), 512 ); }			

			strFullPath = m_strRecordPath[ 2 ] + strFileResolutionName + strFileQualityName + strFileLastName;

			//Dbg( "strFullPath = %s", strFullPath );

			ULONG nStrlen = strFullPath.GetLength();

			CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );			

			//AfxMessageBox( psz );

			QCAP_START_RECORD( m_hVideoDevice[ 2 ], 0, psz );			

			strFullPath.ReleaseBuffer();

			m_bIsRecord3_1 = true;

			m_btnRecord_3.SetWindowText( "Stop Record" );
		}
		else {

			QCAP_STOP_RECORD( m_hVideoDevice[ 2 ], 0, TRUE, 0 );

			m_bIsRecord3_1 = false;			

			m_btnRecord_3.SetWindowText( "Start Record" );
		}
	}		
}

void CMultiRecoderDemoDlg::OnBtnRecord_Ch4_1() 
{
	// TODO: Add your control notification handler code here

	if ( m_bNoSignal[ 3 ] ) { return; }

	if ( m_hVideoDevice[ 3 ] != 0 ) {

		CString strFullPath, strFileResolutionName, strFileQualityName, strFileLastName;

		if ( m_bIsRecord4_1 == 0  ) {

			ULONG nAudioFormat = ( m_nRecordFormat[ 3 ] == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;					

			QCAP_SET_AUDIO_RECORD_PROPERTY( m_hVideoDevice[ 3 ], 0, QCAP_ENCODER_TYPE_SOFTWARE, nAudioFormat );

			ULONG nRecordMode = ( m_nRecordMode[ 3 ] == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

			ULONG nRecordQuality = ( m_nRecordQuality[ 3 ] == 0 ) ? 10000 : 
								   ( m_nRecordQuality[ 3 ] == 1 ) ? 9500 :
								   ( m_nRecordQuality[ 3 ] == 2 ) ? 9000 :
								   ( m_nRecordQuality[ 3 ] == 3 ) ? 8500 :
								   ( m_nRecordQuality[ 3 ] == 4 ) ? 8000 :
								   ( m_nRecordQuality[ 3 ] == 5 ) ? 7500 :
								   ( m_nRecordQuality[ 3 ] == 6 ) ? 7000 :
								   ( m_nRecordQuality[ 3 ] == 7 ) ? 6500 :
								   ( m_nRecordQuality[ 3 ] == 8 ) ? 6000 :
								   ( m_nRecordQuality[ 3 ] == 9 ) ? 5500 :
								   ( m_nRecordQuality[ 3 ] == 10 ) ? 5000 :
								   ( m_nRecordQuality[ 3 ] == 11 ) ? 4500 :
								   ( m_nRecordQuality[ 3 ] == 12 ) ? 4000 :
								   ( m_nRecordQuality[ 3 ] == 13 ) ? 3500 :
								   ( m_nRecordQuality[ 3 ] == 14 ) ? 3000 :
								   ( m_nRecordQuality[ 3 ] == 15 ) ? 2500 :
								   ( m_nRecordQuality[ 3 ] == 16 ) ? 2000 :
								   ( m_nRecordQuality[ 3 ] == 17 ) ? 1500 :
								   ( m_nRecordQuality[ 3 ] == 18 ) ? 1000 :
								   ( m_nRecordQuality[ 3 ] == 19 ) ? 500 : 0;

			ULONG	nRecordBiteRate = ( m_nRecordBiteRate[ 3 ] == 0 ) ? 12 * 1024 * 1024 : 
								   ( m_nRecordBiteRate[ 3 ] == 1 ) ? 10 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 2 ) ? 8 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 3 ) ? 6 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 4 ) ? 4 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 5 ) ? 3 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 6 ) ? 2 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 7 ) ? 1 * 1024 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 8 ) ? 768 * 1024 :
								   ( m_nRecordBiteRate[ 3 ] == 9 ) ? 512 * 1024 : 256 * 1024 ;

			ULONG	nRecordScale = ( m_nRecordScale[ 3 ] == 0 ) ? QCAP_DOWNSCALE_MODE_OFF : 
								   ( m_nRecordScale[ 3 ] == 1 ) ? QCAP_DOWNSCALE_MODE_2_3 :
								   ( m_nRecordScale[ 3 ] == 2 ) ? QCAP_DOWNSCALE_MODE_1_2 : QCAP_DOWNSCALE_MODE_1_4;

			ULONG bRecordSupportGPU = ( m_bRecordSupportGPU[ 3 ] ) ? QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK : QCAP_ENCODER_TYPE_SOFTWARE ;

			QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice[ 3 ], 0, bRecordSupportGPU, QCAP_ENCODER_FORMAT_H264, nRecordMode, nRecordQuality, nRecordBiteRate, 30, 0, 0, nRecordScale );

			if ( nAudioFormat == 0 ) { strFileLastName = _T(".avi"); }
			else { strFileLastName = _T(".mp4"); }

			strFileResolutionName = "unname4";

			if ( m_nRecordBiteRate[ 3 ] == 0 ) { strFileQualityName.Format( _T("_%dM"), 12 ); }

			if ( m_nRecordBiteRate[ 3 ] == 1 ) { strFileQualityName.Format( _T("_%dM"), 10 ); }

			if ( m_nRecordBiteRate[ 3 ] == 2 ) { strFileQualityName.Format( _T("_%dM"), 8 ); }

			if ( m_nRecordBiteRate[ 3 ] == 3 ) { strFileQualityName.Format( _T("_%dM"), 6 ); }

			if ( m_nRecordBiteRate[ 3 ] == 4 ) { strFileQualityName.Format( _T("_%dM"), 4 ); }

			if ( m_nRecordBiteRate[ 3 ] == 5 ) { strFileQualityName.Format( _T("_%dM"), 3 ); }	

			if ( m_nRecordBiteRate[ 3 ] == 6 ) { strFileQualityName.Format( _T("_%dM"), 2 ); }
			
			if ( m_nRecordBiteRate[ 3 ] == 7 ) { strFileQualityName.Format( _T("_%dM"), 1 ); }

			if ( m_nRecordBiteRate[ 3 ] == 8 ) { strFileQualityName.Format( _T("_%dK"), 768 ); }

			if ( m_nRecordBiteRate[ 3 ] == 9 ) { strFileQualityName.Format( _T("_%dK"), 512 ); }			

			strFullPath = m_strRecordPath[ 3 ] + strFileResolutionName + strFileQualityName + strFileLastName;

			ULONG nStrlen = strFullPath.GetLength();

			CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );			

			QCAP_START_RECORD( m_hVideoDevice[ 3 ], 0, psz );

			m_bIsRecord4_1 = true;

			strFullPath.ReleaseBuffer();

			m_btnRecord_4.SetWindowText( "Stop Record" );
		}
		else {

			QCAP_STOP_RECORD( m_hVideoDevice[ 3 ], 0, TRUE, 0 );

			m_bIsRecord4_1 = false;

			m_btnRecord_4.SetWindowText( "Start Record" );
		}
	}		
}

void CMultiRecoderDemoDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	KillTimer( 0x00000001 );

	KillTimer( 0x00000002 );

	// UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUninitialize();
	}
	// UNINITIALIZE USER INTERFACE RESOURCE
	//
	{	m_oChannelWindows_LIVE[ 0 ].DestroyWindow();

		m_oChannelWindows_BK[ 0 ].DestroyWindow();


		m_oChannelWindows_LIVE[ 1 ].DestroyWindow();

		m_oChannelWindows_BK[ 1 ].DestroyWindow();


		m_oChannelWindows_LIVE[ 2 ].DestroyWindow();

		m_oChannelWindows_BK[ 2 ].DestroyWindow();


		m_oChannelWindows_LIVE[ 3 ].DestroyWindow();

		m_oChannelWindows_BK[ 3 ].DestroyWindow();		
	}
	// UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}
	// TODO: Add your message handler code here
	
}

void CMultiRecoderDemoDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnLButtonDown(nFlags, point);

	PostMessage( WM_NCLBUTTONDOWN, HTCAPTION, MAKELPARAM( point.x, point.y ) );
}

BOOL CMultiRecoderDemoDlg::IsReceiveSignal() {

	// CHECK SIGNAL
	//
	BOOL bFlag = 0;

	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ ) {
		
		if ( !m_bNoSignal[ i ] ) { bFlag = 1; }	
	}

	if ( !bFlag ) {
		
		AfxMessageBox( _T("please give a input source!!") );
			
		return FALSE;
	}
	
	return TRUE;
}

void CMultiRecoderDemoDlg::OnButtonShareRecord() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* m_pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	if ( !IsReceiveSignal() ) { return; }

	CString strFullPath, strFileResolutionName, strFileQualityName, strFileLastName;	

	QCAP_STOP_SHARE_RECORD( 0 );

	// 2013.01.04 @ FIXED A BUG WHERE LIVE CHANNEL WOULD APPEAR INCORRECTLY WHILE SHARE RECORD START
	m_bIsSetShareDisplayBuffer = FALSE;

	m_bIsSetShareRecordBuffer = FALSE;

		
	ULONG nChannelNum = -1;

	if ( m_pMainDlg->m_bShareRecordCH[ 0 ] == 1 ) { nChannelNum = 0; }
		
	if ( m_pMainDlg->m_bShareRecordCH[ 1 ] == 1 ) { nChannelNum = 1; }

	if ( m_pMainDlg->m_bShareRecordCH[ 2 ] == 1 ) { nChannelNum = 2; }

	if ( m_pMainDlg->m_bShareRecordCH[ 3 ] == 1 ) { nChannelNum = 3; }

	if ( nChannelNum == -1 ) { return; }

	// SET SHARE RECORD PROPERTY FOR AUDIO
	//
	ULONG nAudioFormat = ( m_nShareRecordAudioFormat == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;		
	
	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, nAudioFormat, 2, 16, 48000, 100 );

	// SET SHARE RECORD PROPERTY FOR VIDEO
	//
	ULONG nShareRecordMode = ( m_nShareRecordMode == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

	ULONG nShareRecordVideoWidth = 1920;

	ULONG nShareRecordVideoHeight = 1080;

	if ( m_nShareRecordStandard == 0 ) {			// NTSC
		
		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 720 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 480 ; 
		}
	else {

		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 576 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 576 ;		
	}

	ULONG nShareRecordFrameRatePos = ( m_nShareRecordFrameRatePos == 0 ) ? ( m_nShareRecordStandard == 0 ) ? 60 : 50 :
									 ( m_nShareRecordFrameRatePos == 1 ) ? ( m_nShareRecordStandard == 0 ) ? 30 : 25 :
									 ( m_nShareRecordFrameRatePos == 2 ) ? 15 :
									 ( m_nShareRecordFrameRatePos == 3 ) ? 7 : 3;

	ULONG nShareRecordQuality = ( m_nShareRecordQuality == 0 ) ? 10000 : 
								( m_nShareRecordQuality == 1 ) ? 9500 :
								( m_nShareRecordQuality == 2 ) ? 9000 :
								( m_nShareRecordQuality == 3 ) ? 8500 :
								( m_nShareRecordQuality == 4 ) ? 8000 :
								( m_nShareRecordQuality == 5 ) ? 7500 :
								( m_nShareRecordQuality == 6 ) ? 7000 :
								( m_nShareRecordQuality == 7 ) ? 6500 :
								( m_nShareRecordQuality == 8 ) ? 6000 :
								( m_nShareRecordQuality == 9 ) ? 5500 :
								( m_nShareRecordQuality == 10 ) ? 5000 :
								( m_nShareRecordQuality == 11 ) ? 4500 :
								( m_nShareRecordQuality == 12 ) ? 4000 :
								( m_nShareRecordQuality == 13 ) ? 3500 :
								( m_nShareRecordQuality == 14 ) ? 3000 :
								( m_nShareRecordQuality == 15 ) ? 2500 :
								( m_nShareRecordQuality == 16 ) ? 2000 :
								( m_nShareRecordQuality == 17 ) ? 1500 :
								( m_nShareRecordQuality == 18 ) ? 1000 :
								( m_nShareRecordQuality == 19 ) ? 500 : 0;	

	ULONG	nShareRecordBiteRate = ( m_nShareRecordBiteRate == 0 ) ? 12 * 1024 * 1024 : 
								   ( m_nShareRecordBiteRate == 1 ) ? 10 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 2 ) ? 8 * 1024 * 1024 :
							       ( m_nShareRecordBiteRate == 3 ) ? 6 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 4 ) ? 4 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 5 ) ? 3 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 6 ) ? 2 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 7 ) ? 1 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 8 ) ? 768 * 1024 :
								   ( m_nShareRecordBiteRate == 9 ) ? 512 * 1024 : 256 * 1024 ;

	ULONG	nShareRecordScale = ( m_nShareRecordScale == 0 ) ? QCAP_DOWNSCALE_MODE_OFF : 
							    ( m_nShareRecordScale == 1 ) ? QCAP_DOWNSCALE_MODE_2_3 :
							    ( m_nShareRecordScale == 2 ) ? QCAP_DOWNSCALE_MODE_1_2 : QCAP_DOWNSCALE_MODE_1_4;

	ULONG	bShareRecordSupportGPU = ( m_bShareRecordSupportGPU ) ? QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK : QCAP_ENCODER_TYPE_SOFTWARE ;

	// 2012.12.26 custom setting
	if ( m_bIsShareDisplay ) {
		
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, bShareRecordSupportGPU, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nShareRecordVideoWidth, nShareRecordVideoHeight, nShareRecordFrameRatePos, nShareRecordMode, nShareRecordQuality, nShareRecordBiteRate, 30, 0, 0, m_oShareWindows.m_hWnd, TRUE );
	}
	else {
		
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, bShareRecordSupportGPU, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nShareRecordVideoWidth, nShareRecordVideoHeight, nShareRecordFrameRatePos, nShareRecordMode, nShareRecordQuality, nShareRecordBiteRate, 30, 0, 0, NULL, TRUE );
	}		

	//::GetModuleFileName( 0, m_pMainDlg->m_strShareRecordPath.GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );					// SET PAHT
		
	if ( nAudioFormat == 0 ) {
			
		strFileLastName = _T(".avi");
	}
	else {
			
		strFileLastName = _T(".mp4");
	}

	if ( m_nShareRecordResolutionPos == 0 ) { strFileResolutionName = "ShareRecord_1080"; }

	if ( m_nShareRecordResolutionPos == 1 ) { strFileResolutionName = "ShareRecord_720"; }

	if ( m_nShareRecordResolutionPos == 0 ) {
					
		if ( m_nShareRecordResolutionPos == 2 ) { strFileResolutionName = "ShareRecord_480"; }
	}
	else {
				
		if ( m_nShareRecordResolutionPos == 2 ) { strFileResolutionName = "ShareRecord_576"; }
	}

	if ( m_nShareRecordBiteRate == 0 ) { strFileQualityName.Format( _T("_%dM"), 12 ); }
	if ( m_nShareRecordBiteRate == 1 ) { strFileQualityName.Format( _T("_%dM"), 10 ); }
	if ( m_nShareRecordBiteRate == 2 ) { strFileQualityName.Format( _T("_%dM"), 8 ); }
	if ( m_nShareRecordBiteRate == 3 ) { strFileQualityName.Format( _T("_%dM"), 6 ); }
	if ( m_nShareRecordBiteRate == 4 ) { strFileQualityName.Format( _T("_%dM"), 4 ); }
	if ( m_nShareRecordBiteRate == 5 ) { strFileQualityName.Format( _T("_%dM"), 3 ); }
	if ( m_nShareRecordBiteRate == 6 ) { strFileQualityName.Format( _T("_%dM"), 2 ); }			
	if ( m_nShareRecordBiteRate == 7 ) { strFileQualityName.Format( _T("_%dM"), 1 ); }
	if ( m_nShareRecordBiteRate == 8 ) { strFileQualityName.Format( _T("_%dK"), 768 ); }
	if ( m_nShareRecordBiteRate == 9 ) { strFileQualityName.Format( _T("_%dK"), 512 ); }			

	strFullPath = m_strShareRecordPath + strFileResolutionName + strFileQualityName + strFileLastName;
		
	ULONG nStrlen = strFullPath.GetLength();

	CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

	//AfxMessageBox( psz );

	if ( m_bIsShareRecord == 0  ) {

		QCAP_START_SHARE_RECORD( 0, psz );

		m_bIsSetShareRecordBuffer = TRUE;

		m_bIsShareRecord = TRUE;

		m_btnShareRecord.SetWindowText( "Stop Record" );	
		
		((CButton*)GetDlgItem( IDC_CHECK_SHARE_DIASPLAY ))->EnableWindow( FALSE );

		((CButton*)GetDlgItem( IDC_BUTTON_SHARE_PROPERTY ))->EnableWindow( FALSE );
	}
	else {
	
		QCAP_START_SHARE_RECORD( 0, psz, 0x00000004 );

		m_bIsShareRecord = FALSE;

		// 2013.01.04 @ FIXED A BUG WHERE LIVE CHANNEL WOULD APPEAR INCORRECTLY WHILE SHARE RECORD START
		m_bIsSetShareDisplayBuffer = TRUE;

		m_btnShareRecord.SetWindowText( "Start Record" );

		((CButton*)GetDlgItem( IDC_CHECK_SHARE_DIASPLAY ))->EnableWindow( TRUE );
		
		((CButton*)GetDlgItem( IDC_BUTTON_SHARE_PROPERTY ))->EnableWindow( TRUE );
	}

	strFullPath.ReleaseBuffer();
}

void CMultiRecoderDemoDlg::OnBtnLiveProperty1() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg dlgLivProperty;

	dlgLivProperty.m_hDev = pMainDlg->m_hVideoDevice[ 0 ];

	dlgLivProperty.m_nLiveChannelNum = 0;

	dlgLivProperty.DoModal();
}

void CMultiRecoderDemoDlg::OnBtnLiveProperty2() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg dlgLivProperty;

	dlgLivProperty.m_hDev = pMainDlg->m_hVideoDevice[ 1 ];

	dlgLivProperty.m_nLiveChannelNum = 1;

	dlgLivProperty.DoModal();
}

void CMultiRecoderDemoDlg::OnBtnLiveProperty3() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg dlgLivProperty;

	dlgLivProperty.m_hDev = pMainDlg->m_hVideoDevice[ 2 ];

	dlgLivProperty.m_nLiveChannelNum = 2;

	dlgLivProperty.DoModal();
}

void CMultiRecoderDemoDlg::OnBtnLiveProperty4() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg dlgLivProperty;

	dlgLivProperty.m_hDev = pMainDlg->m_hVideoDevice[ 3 ];

	dlgLivProperty.m_nLiveChannelNum = 3;

	dlgLivProperty.DoModal();
}

void CMultiRecoderDemoDlg::OnBtnSnapshot1() 
{
	// TODO: Add your control notification handler code here

	if ( m_hVideoDevice[ 0 ] != 0 ) {
		
		CString strFullPath;

		if ( m_nSnapshotType[ 0 ] ) {

			strFullPath.Format( _T("%s\\unname%d.bmp"), m_strSnapshotPath[ 0 ], 0 );
		}
		else {
		
			strFullPath.Format( _T("%s\\unname%d.jpg"), m_strSnapshotPath[ 0 ], 0 );
		}		
		
		ULONG nStrlen = strFullPath.GetLength();

		CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

		if ( m_nSnapshotType[ 0 ] ) { QCAP_SNAPSHOT_BMP( m_hVideoDevice[ 0 ], psz ); }		
		else { QCAP_SNAPSHOT_JPG( m_hVideoDevice[ 0 ], psz, 100); }
        
		strFullPath.ReleaseBuffer();
	}
}

void CMultiRecoderDemoDlg::OnBtnSnapshot2() 
{
	// TODO: Add your control notification handler code here

	if ( m_hVideoDevice[ 1 ] != 0 ) {
		
		CString strFullPath;

		if ( m_nSnapshotType[ 1 ] ) {
		
			strFullPath.Format( _T("%s\\unname%d.bmp"), m_strSnapshotPath[ 1 ], 1 );			
		}
		else {

			strFullPath.Format( _T("%s\\unname%d.jpg"), m_strSnapshotPath[ 1 ], 1 );				
		}		
		
		ULONG nStrlen = strFullPath.GetLength();

		CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

		if ( m_nSnapshotType[ 1 ] ) { QCAP_SNAPSHOT_BMP( m_hVideoDevice[ 1 ], psz ); }		
		else { QCAP_SNAPSHOT_JPG( m_hVideoDevice[ 1 ], psz, 100); }

		strFullPath.ReleaseBuffer();
	}	
}

void CMultiRecoderDemoDlg::OnBtnSnapshot3() 
{
	// TODO: Add your control notification handler code here
	
	if ( m_hVideoDevice[ 2 ] != 0 ) {
		
		CString strFullPath;

		if ( m_nSnapshotType[ 2 ] ) {
		
			strFullPath.Format( _T("%s\\unname%d.bmp"), m_strSnapshotPath[ 2 ], 2 );			
		}
		else {		
			
			strFullPath.Format( _T("%s\\unname%d.jpg"), m_strSnapshotPath[ 2 ], 2 );
		}		
		
		ULONG nStrlen = strFullPath.GetLength();

		CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

		if ( m_nSnapshotType[ 2 ] ) { QCAP_SNAPSHOT_BMP( m_hVideoDevice[ 2 ], psz ); }		
		else { QCAP_SNAPSHOT_JPG( m_hVideoDevice[ 2 ], psz, 100); }

		strFullPath.ReleaseBuffer();
	}
}

void CMultiRecoderDemoDlg::OnBtnSnapshot4() 
{
	// TODO: Add your control notification handler code here

	if ( m_hVideoDevice[ 3 ] != 0 ) {
		
		CString strFullPath;

		if ( m_nSnapshotType[ 3 ] ) {
		
			strFullPath.Format( _T("%s\\unname%d.bmp"), m_strSnapshotPath[ 3 ], 3 );
		}
		else {
		
			strFullPath.Format( _T("%s\\unname%d.jpg"), m_strSnapshotPath[ 3 ], 3 );			
		}		
		
		ULONG nStrlen = strFullPath.GetLength();

		CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

		if ( m_nSnapshotType[ 3 ] ) { QCAP_SNAPSHOT_BMP( m_hVideoDevice[ 3 ], psz ); }		
		else { QCAP_SNAPSHOT_JPG( m_hVideoDevice[ 3 ], psz, 100); }

		strFullPath.ReleaseBuffer();
	}
}

void CMultiRecoderDemoDlg::OnButtonShareProperty() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CShareRecord dlgShareRecordDlg;

	dlgShareRecordDlg.m_hDev = pMainDlg->m_hVideoDevice[ 0 ];

	dlgShareRecordDlg.m_nLiveChannelNum = 0;

	dlgShareRecordDlg.DoModal();
}

void CMultiRecoderDemoDlg::OnCheckShareDiasplay() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	m_bIsShareDisplay = ((CButton*)GetDlgItem( IDC_CHECK_SHARE_DIASPLAY ))->GetCheck();

	CString strFullPath, strFileResolutionName, strFileQualityName, strFileLastName;

	QCAP_STOP_SHARE_RECORD( 0 );
		
	ULONG nChannelNum = -1;

	if ( m_bShareRecordCH[ 0 ] == 1 ) { nChannelNum = 0; }
		
	if ( m_bShareRecordCH[ 1 ] == 1 ) { nChannelNum = 1; }

	if ( m_bShareRecordCH[ 2 ] == 1 ) { nChannelNum = 2; }

	if ( m_bShareRecordCH[ 3 ] == 1 ) { nChannelNum = 3; }

	if ( nChannelNum == -1 ) { return; }

	// SET SHARE RECORD PROPERTY FOR AUDIO
	//
	ULONG nAudioFormat = ( m_nShareRecordAudioFormat == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;		
	
	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, nAudioFormat, 2, 16, 48000, 100 );

	// SET SHARE RECORD PROPERTY FOR VIDEO
	//
	ULONG nShareRecordMode = ( m_nShareRecordMode == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

	ULONG nShareRecordVideoWidth = 1920;

	ULONG nShareRecordVideoHeight = 1080;

	if ( m_nShareRecordStandard == 0 ) {			// NTSC
		
		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 720 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 480 ; 
	}
	else {

		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 576 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 576 ;		
	}

	ULONG nShareRecordQuality = ( m_nShareRecordQuality == 0 ) ? 10000 : 
								( m_nShareRecordQuality == 1 ) ? 9500 :
								( m_nShareRecordQuality == 2 ) ? 9000 :
								( m_nShareRecordQuality == 3 ) ? 8500 :
								( m_nShareRecordQuality == 4 ) ? 8000 :
								( m_nShareRecordQuality == 5 ) ? 7500 :
								( m_nShareRecordQuality == 6 ) ? 7000 :
								( m_nShareRecordQuality == 7 ) ? 6500 :
								( m_nShareRecordQuality == 8 ) ? 6000 :
								( m_nShareRecordQuality == 9 ) ? 5500 :
								( m_nShareRecordQuality == 10 ) ? 5000 :
								( m_nShareRecordQuality == 11 ) ? 4500 :
								( m_nShareRecordQuality == 12 ) ? 4000 :
								( m_nShareRecordQuality == 13 ) ? 3500 :
								( m_nShareRecordQuality == 14 ) ? 3000 :
								( m_nShareRecordQuality == 15 ) ? 2500 :
								( m_nShareRecordQuality == 16 ) ? 2000 :
								( m_nShareRecordQuality == 17 ) ? 1500 :
								( m_nShareRecordQuality == 18 ) ? 1000 :
								( m_nShareRecordQuality == 19 ) ? 500 : 0;	

	ULONG	nShareRecordBiteRate = ( m_nShareRecordBiteRate == 0 ) ? 12 * 1024 * 1024 : 
								   ( m_nShareRecordBiteRate == 1 ) ? 10 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 2 ) ? 8 * 1024 * 1024 :
							       ( m_nShareRecordBiteRate == 3 ) ? 6 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 4 ) ? 4 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 5 ) ? 3 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 6 ) ? 2 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 7 ) ? 1 * 1024 * 1024 :
								   ( m_nShareRecordBiteRate == 8 ) ? 768 * 1024 :
								   ( m_nShareRecordBiteRate == 9 ) ? 512 * 1024 : 256 * 1024 ;
	
	ULONG	nShareRecordScale = ( m_nShareRecordScale == 0 ) ? QCAP_DOWNSCALE_MODE_OFF : 
							    ( m_nShareRecordScale == 1 ) ? QCAP_DOWNSCALE_MODE_2_3 :
							    ( m_nShareRecordScale == 2 ) ? QCAP_DOWNSCALE_MODE_1_2 : QCAP_DOWNSCALE_MODE_1_4;

	ULONG	bShareRecordSupportGPU = ( m_bShareRecordSupportGPU ) ? QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK : QCAP_ENCODER_TYPE_SOFTWARE ;

	
	// 2012.12.26 custom setting
	if ( m_bIsShareDisplay ) {
		
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nShareRecordVideoWidth, nShareRecordVideoHeight, 30, nShareRecordMode, nShareRecordQuality, nShareRecordBiteRate, 30, 0, 0, m_oShareWindows.m_hWnd, TRUE );
	}
	else {
		
		QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'U', 'Y', '2'), nShareRecordVideoWidth, nShareRecordVideoHeight, 30, nShareRecordMode, nShareRecordQuality, nShareRecordBiteRate, 30, 0, 0, NULL, TRUE );
	}		
		
	if ( nAudioFormat == 0 ) {
			
		strFileLastName = _T(".avi");
	}
	else {
			
		strFileLastName = _T(".mp4");
	}

	if ( m_nShareRecordResolutionPos == 0 ) { strFileResolutionName = "\\ShareRecord_1080"; }

	if ( m_nShareRecordResolutionPos == 1 ) { strFileResolutionName = "\\ShareRecord_720"; }

	if ( m_nShareRecordResolutionPos == 0 ) {
					
		if ( m_nShareRecordResolutionPos == 2 ) { strFileResolutionName = "\\ShareRecord_480"; }
	}
	else {
				
		if ( m_nShareRecordResolutionPos == 2 ) { strFileResolutionName = "\\ShareRecord_576"; }
	}

	if ( m_nShareRecordBiteRate == 0 ) { strFileQualityName.Format( _T("_%dM"), 12 ); }
	if ( m_nShareRecordBiteRate == 1 ) { strFileQualityName.Format( _T("_%dM"), 10 ); }
	if ( m_nShareRecordBiteRate == 2 ) { strFileQualityName.Format( _T("_%dM"), 8 ); }
	if ( m_nShareRecordBiteRate == 3 ) { strFileQualityName.Format( _T("_%dM"), 6 ); }
	if ( m_nShareRecordBiteRate == 4 ) { strFileQualityName.Format( _T("_%dM"), 4 ); }
	if ( m_nShareRecordBiteRate == 5 ) { strFileQualityName.Format( _T("_%dM"), 3 ); }
	if ( m_nShareRecordBiteRate == 6 ) { strFileQualityName.Format( _T("_%dM"), 2 ); }			
	if ( m_nShareRecordBiteRate == 7 ) { strFileQualityName.Format( _T("_%dM"), 1 ); }
	if ( m_nShareRecordBiteRate == 8 ) { strFileQualityName.Format( _T("_%dK"), 768 ); }
	if ( m_nShareRecordBiteRate == 9 ) { strFileQualityName.Format( _T("_%dK"), 512 ); }

	strFullPath = m_strShareRecordPath + strFileResolutionName + strFileQualityName + strFileLastName;
		
	ULONG nStrlen = strFullPath.GetLength();

	CHAR* psz = strFullPath.GetBuffer( nStrlen+1 );

	QCAP_START_SHARE_RECORD( 0, psz, 0x00000004);
}


BOOL CMultiRecoderDemoDlg::SetShareFormatChangedOutput_CShareRecord() {

	ULONG nAudioFormat = ( m_nShareRecordAudioFormat == 0 ) ? QCAP_ENCODER_FORMAT_PCM : QCAP_ENCODER_FORMAT_AAC;		
	
	ULONG nShareRecordMode = ( m_nShareRecordMode == 0 ) ? QCAP_RECORD_MODE_VBR : QCAP_RECORD_MODE_CBR;

	ULONG nShareRecordVideoWidth = 1920;

	ULONG nShareRecordVideoHeight = 1080;

	if ( m_nShareRecordStandard == 0 ) {													// NTSC
		
		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 720 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 480 ; 
		}
	else {

		nShareRecordVideoWidth = ( m_nShareRecordResolutionPos == 0 ) ? 1920 : 
								 ( m_nShareRecordResolutionPos == 1 ) ? 1280 : 576 ; 


		nShareRecordVideoHeight = ( m_nShareRecordResolutionPos == 0 ) ? 1080 : 
								  ( m_nShareRecordResolutionPos == 1 ) ? 720 : 576 ;		
	}

	ULONG nShareRecordFrameRatePos = ( m_nShareRecordFrameRatePos == 0 ) ? ( m_nShareRecordStandard == 0 ) ? 60 : 50 :
									 ( m_nShareRecordFrameRatePos == 1 ) ? ( m_nShareRecordStandard == 0 ) ? 30 : 25 :
									 ( m_nShareRecordFrameRatePos == 2 ) ? 15 :
									 ( m_nShareRecordFrameRatePos == 3 ) ? 7 : 3;

	// SHARE WINDOW INFO (DEFAULT)
	//
	m_strShareFormatChangedOutput.Format( "CH%02d:%dx%d@%dFPS,%dCH@%dBitsx%dHz",
											m_nShareDisplayChannelNumber + 1,
											nShareRecordVideoWidth,
											nShareRecordVideoHeight,
											nShareRecordFrameRatePos,
											m_nAudioChannels[ m_nShareDisplayChannelNumber ],
											m_nAudioBitsPerSample[ m_nShareDisplayChannelNumber ],
											m_nAudioSampleFrequency[ m_nShareDisplayChannelNumber ]);
	
	return TRUE;
}

void CMultiRecoderDemoDlg::OnButtonShareStreamming() 
{
	// TODO: Add your control notification handler code here

	if ( !IsReceiveSignal() ) { return; }
	
	// ONLY FIRST TIME, TO CREATE STREAMMING SERVER
	//
	if ( !m_hStreamServer ) {
		
		QCAP_CREATE_BROADCAST_RTSP_SERVER(0, 4, &m_hStreamServer, "root", "root", 554 );
	}

	// CHECK AND CONFIRM THE SERVER WORKS NORMALLY
	//
	{	if ( !m_hStreamServer ) {
		
			AfxMessageBox( _T("please give a input source!!") );
			
			return;
		}
	}		

	// ENTER STREAMMING ACT
	//
	if ( !m_bIsSetShareStreammingBuffer ) {
		
		// SETTING PROPERTY
		//
		QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hStreamServer,
			0 /*CH01*/,
			QCAP_ENCODER_TYPE_SOFTWARE,
			QCAP_ENCODER_FORMAT_H264,
			QCAP_COLORSPACE_TYEP_YUY2 ,
			(m_nVideoWidth[ m_nShareDisplayChannelNumber ] / 2),
			(m_nVideoHeight[ m_nShareDisplayChannelNumber ] / 2),
			//m_nVideoFrameRate[ m_nShareDisplayChannelNumber ],
			30,
			QCAP_RECORD_MODE_CBR,
			8000,
			(8 * 1024 * 1024 / 4),
			30,
			0,
			0,
			NULL,
			TRUE,
			FALSE,
			0x00000003 );
		
		//QCAP_SET_AUDIO_BROADCAST_PROPERTY( m_hStreamServer, 0 /*CH01*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, m_nAudioVolume[ m_nShareDisplayChNum ] );
		QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hStreamServer,
			0 /*CH01*/,
			QCAP_ENCODER_TYPE_SOFTWARE,
			QCAP_ENCODER_FORMAT_AAC,
			2,
			16,
			48000,
			0 );		

		// RUN
		//
		QCAP_START_BROADCAST_SERVER( m_hStreamServer );
	
		m_bIsSetShareStreammingBuffer = TRUE;

		m_btnStreamming.SetWindowText( "Stop Streamming" );	
	}
	else {

		QCAP_STOP_BROADCAST_SERVER( m_hStreamServer );

		m_bIsSetShareStreammingBuffer = FALSE;

		m_btnStreamming.SetWindowText( "Start Streamming" );
	}
}

CString CMultiRecoderDemoDlg::GetAppPath()
{
	CHAR sz[ MAX_PATH ];

	CHAR szModulPath[ MAX_PATH ];

	CHAR* psz = szModulPath;

	::GetModuleFileName( 0, sz, strlen( sz ) + 1 );
	
	psz = strrchr( sz, '\\');

	ULONG len = psz - sz + 1;

	strncpy( szModulPath, sz, len );

	szModulPath[ len ] = '\0';

	return szModulPath;
}

BYTE CMultiRecoderDemoDlg::SetIniFile( LPCTSTR lpc )
{
	CFile oFile;
	
	CFileStatus oStatus;

	// 0 is not exists when opening a settings file.
	BOOL bResult = oFile.Open( lpc,CFile::shareDenyNone );

	BYTE status = 0;

	if ( !bResult ) {		

		Dbg( "CMultiRecoderDemoDlg::SetIniFile.oFile is not exsits!!\n" );

		status |= INI_RS_ERROR_FILE_NOT_EXIST;
		
		// CFile::modeNoTruncate Hl[覡} pGsb }åBN׸ms pG󤣦sb|~
		if ( oFile.Open( lpc, CFile::modeCreate | CFile::modeReadWrite | CFile::modeNoTruncate ) ) {
				
			Dbg( "CMultiRecoderDemoDlg::SetIniFile.oFile.Open is successed created!!\n" );

			//bResult = TRUE;

			status |= INI_RS_SUCCESSFUL;
		}
		else {

			Dbg( "CMultiRecoderDemoDlg::SetIniFile.oFile.Open is failed created!!\n" );
				
			//bResult = FALSE;

			status |= INI_RS_ERROR_GENERAL;
		}
	}
	else {
		
		Dbg( "CMultiRecoderDemoDlg::SetIniFile.oFile is already exsits!!\n" );

		status |= INI_RS_ERROR_FILE_EXIST;
	}

	/*
	if ( !oFile.GetStatus( lpc, oStatus ) ) {

		Dbg( "CMultiRecoderDemoDlg::SetINIFile\nFile Size = %d", oStatus.m_size );	
			
		return TRUE;
	}
	*/

	//_strFileName = lpc;

	oFile.Close();

	//return bResult;
	return status;
}

BOOL CMultiRecoderDemoDlg::SetProfileData( CString strFileName )
{
	ULONG nStatus = 0x00000000;

	CHAR szTemp[ MAX_PATH ] ={ 0 };

	//SLiveData sLiveData[ 4 ];

	for ( ULONG i = 0; i < 4; i++ ) {
	
		m_sLiveData[ i ].nId = (BYTE)i;

		memset( &m_sLiveData[ i ], 0, sizeof( m_sLiveData[ i ] ) );

		m_sLiveData[ i ].dwSize = sizeof( m_sLiveData[ i ] );
		
		// SETTING SECTION ( RecordPanel )
		wsprintf( m_sLiveData[ i ].szSecRecord, "RecordPanel%d", i );
		
		// RECORD PATH
		//
		//memset( szSection, 0, sizeof( szSection ) );
		wsprintf( m_sLiveData[ i ].szKeyRecordPath, "RecordPath" );
		wsprintf( m_sLiveData[ i ].szValueRecordPath, "%s", m_strRecordPath[ i ] );
		WritePrivateProfileString( m_sLiveData[ i ].szSecRecord, m_sLiveData[ i ].szKeyRecordPath, m_sLiveData[ i ].szValueRecordPath, strFileName );

		// RECORD FILE FORMAT
		//
		wsprintf( m_sLiveData[ i ].szKeyFileFormat, "FileFormat" );
		m_sLiveData[ i ].nValueFileFormat = m_nRecordFormat[ i ];
		itoa( m_sLiveData[ i ].nValueFileFormat, szTemp, 10 );
		WritePrivateProfileString( m_sLiveData[ i ].szSecRecord, m_sLiveData[ i ].szKeyFileFormat, szTemp, strFileName );

		// RECORD FILE STANDARD
		//
		sprintf( m_sLiveData[ i ].szKeyFileStandard, "FileStandard" );
		m_sLiveData[ i ].nValueFileStandard = m_nRecordStandard[ i ];
		itoa( m_sLiveData[ i ].nValueFileStandard, szTemp, 10 );
		WritePrivateProfileString( m_sLiveData[ i ].szSecRecord, m_sLiveData[ i ].szKeyFileStandard, szTemp, strFileName );
	}
	
	BOOL bCreate = FALSE;
	
	return TRUE;
}

BOOL CMultiRecoderDemoDlg::GetProfileData( CString strFileName )
{
	ULONG nStatus = 0x00000000;

	TCHAR szTemp[ MAX_PATH ] ={ 0 };

	for ( ULONG i = 0; i < 4; i++ ) {
	
		m_sLiveData[ i ].nId = (BYTE)i;

		memset( &m_sLiveData[ i ], 0, sizeof( m_sLiveData[ i ] ) );

		m_sLiveData[ i ].dwSize = sizeof( m_sLiveData[ i ] );
		
		wsprintf( m_sLiveData[ i ].szSecRecord, "RecordPanel%d", i );
		
		// RECORD PATH
		//
		//memset( szSection, 0, sizeof( szSection ) );
		wsprintf( m_sLiveData[ i ].szKeyRecordPath, "RecordPath" );
		wsprintf( m_sLiveData[ i ].szValueRecordPath, "%s", m_strRecordPath[ i ] );
		GetPrivateProfileString( m_sLiveData[ i ].szSecRecord, m_sLiveData[ i ].szKeyRecordPath, "D:\\", m_sLiveData[ i ].szValueRecordPath ,MAX_VALUE, strFileName ); 
		m_strRecordPath[ i ] = m_sLiveData[ i ].szValueRecordPath;
		Dbg( "%s\n", m_sLiveData[ i ].szValueRecordPath ); 

		// RECORD FILE FORMAT
		//
		wsprintf( m_sLiveData[ i ].szKeyFileFormat, "FileFormat" );
		m_sLiveData[ i ].nValueFileFormat = GetPrivateProfileInt( m_sLiveData[ i ].szSecRecord, m_sLiveData[ i ].szKeyFileFormat, 0, strFileName ); 
		m_nRecordFormat[ i ] = m_sLiveData[ i ].nValueFileFormat;
		Dbg( "0x%08x\n", m_sLiveData[ i ].nValueFileFormat ); 

		// RECORD FILE STANDARD
		//
		wsprintf( m_sLiveData[ i ].szKeyFileStandard, "FileStandard" );
		m_sLiveData[ i ].nValueFileStandard = GetPrivateProfileInt( m_sLiveData[ i ].szSecRecord, m_sLiveData[ i ].szKeyFileStandard, 0, strFileName ); 
		m_nRecordStandard[ i ] = m_sLiveData[ i ].nValueFileStandard;
		Dbg( "0x%08x\n", m_sLiveData[ i ].nValueFileStandard ); 
	}

	return TRUE;
}
