// SnapshotPanel.cpp : implementation file
//

#include "stdafx.h"
#include "MultiRecoderDemo.h"
#include "SnapshotPanel.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "MultiRecoderDemoDlg.h"

#include "LivePropertyDlg.h"

/////////////////////////////////////////////////////////////////////////////
// CSnapshotPanel dialog


CSnapshotPanel::CSnapshotPanel(CWnd* pParent /*=NULL*/)
	: CDialog(CSnapshotPanel::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSnapshotPanel)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CSnapshotPanel::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSnapshotPanel)
	DDX_Control(pDX, IDC_EDIT_SNAPSHOT_PATH, m_editSnapPath);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSnapshotPanel, CDialog)
	//{{AFX_MSG_MAP(CSnapshotPanel)
	ON_BN_CLICKED(IDC_BUTTON, OnButton)
	ON_BN_CLICKED(IDC_BUTTON_OK, OnButtonOk)
	ON_BN_CLICKED(IDC_BUTTON_NO, OnButtonNo)
	ON_BN_CLICKED(IDC_RADIO_BMP, OnRadioBmp)
	ON_BN_CLICKED(IDC_RADIO_JPG, OnRadioJpg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSnapshotPanel message handlers



void CSnapshotPanel::OnButton() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

    char szPath[ 1024 ];     

    CString str;

    ZeroMemory( szPath, sizeof(szPath) );   

    BROWSEINFO bi;
    bi.hwndOwner		= m_hWnd;
    bi.pidlRoot			= NULL;   
    bi.pszDisplayName	= szPath;   
    bi.lpszTitle		= "Select Record Path:";   
    bi.ulFlags			= 0;   
    bi.lpfn				= NULL;   
    bi.lParam			= 0;   
    bi.iImage			= 0;   
    
    LPITEMIDLIST lp		= SHBrowseForFolder(&bi);   

    if( lp && SHGetPathFromIDList( lp, szPath ) ) {

        str.Format( "%s",  szPath );

		pMainDlg->m_strSnapshotPath[ nChannelNum ] = str;

		m_editSnapPath.SetWindowText( (LPCTSTR)pMainDlg->m_strSnapshotPath[ nChannelNum ] );     
    }
    else {

		AfxMessageBox("The Direction Not Exist");   	
	}    	
}

BOOL CSnapshotPanel::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	// SETTING SNAPSHOT PATH
	//
	CString strFullPathName;

	strFullPathName =  pMainDlg->m_strSnapshotPath[ nChannelNum ];

	m_editSnapPath.SetWindowText( strFullPathName );

	// SETTING SNAPSHOT TYPE
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {		

		if ( pMainDlg->m_nSnapshotType[ nChannelNum ] == 0 ) { CheckDlgButton( IDC_RADIO_BMP, BST_CHECKED ); }

		if ( pMainDlg->m_nSnapshotType[ nChannelNum ] == 1 ) { CheckDlgButton( IDC_RADIO_JPG, BST_CHECKED ); }
	}

	// SETTING SNAPSHOT DURATINO
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_DURATINO ))->SetCurSel( pMainDlg->m_nSnapshotSyncDuration[ nChannelNum ] );
	}

	// SETTING SNAPSHOT CONTINUOUS
	//
	if ( pMainDlg->m_hVideoDevice[ nChannelNum ] != 0 ) {	
		
		((CComboBox*)GetDlgItem( IDC_COMBO_DURATINO2 ))->SetCurSel( pMainDlg->m_nContinueSnapshotNum[ nChannelNum ] );
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSnapshotPanel::OnButtonOk() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	m_pMainParent->SendMessage( WM_CLOSE );
	
	//m_pMainParent->DestroyWindow();

	CDialog::OnOK();	
}

void CSnapshotPanel::OnButtonNo() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;
	
	m_pMainParent->SendMessage( WM_CLOSE );
	
	//m_pMainParent->DestroyWindow();

	CDialog::OnOK();	
}

void CSnapshotPanel::OnRadioBmp() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nSnapshotType[ nChannelNum ] = 0x00000000;		
}

void CSnapshotPanel::OnRadioJpg() 
{
	// TODO: Add your control notification handler code here

	CMultiRecoderDemoDlg* pMainDlg = CMultiRecoderDemoDlg::s_pCMultiRecoderDemoDlg;

	CLivePropertyDlg* m_pMainParent = (CLivePropertyDlg*)GetParent()->GetParent();

	ULONG nChannelNum = m_pMainParent->m_nLiveChannelNum;

	pMainDlg->m_nSnapshotType[ nChannelNum ] = 0x00000001;		
}
