#ifndef LINUXXWIN_H
#define LINUXXWIN_H

#include <stdio.h>					// SYSTEM
#include <stdlib.h>					// SYSTEM
#include <string.h>					// SYSTEM
#include <pthread.h>				// SYSTEM
#include <X11/Xlib.h>				// XWINDOW
#include <X11/keysym.h>				// XWINDOW
#include <X11/extensions/Xvlib.h>	// XVIDEO.EXTENSION
#include <linux/videodev2.h>		// V4L2
#include <sys/stat.h>				// V4L2
#include <sys/ioctl.h>				// V4L2
#include <sys/mman.h>				// V4L2
#include <fcntl.h>					// V4L2
#include <errno.h>					// V4L2

#include <getopt.h>					// get long option

#define _GNU_SOURCE					// for get long option

typedef          char           CHAR;
typedef          short         SHORT;
typedef          long           LONG;
typedef     long long       LONGLONG;
typedef unsigned char          UCHAR;
typedef unsigned short        USHORT;
typedef unsigned long          ULONG;
typedef unsigned long long ULONGLONG;
typedef unsigned char           BYTE;
typedef unsigned short          WORD;
typedef unsigned long          DWORD;
typedef unsigned char        BOOLEAN;
typedef void                    VOID;
typedef void *                 PVOID;

#define LINUXXWIN_PRINT( msg... )	fprintf( stderr, "[LINUXXWIN] : " msg )

#define LINUXXWIN_DEBUG( msg... )	fprintf( stderr, "[LINUXXWIN] : " msg )

//#define LINUXXWIN_DEBUG( msg... )

#define FREE( p ) { if( p ) { free( p ); p = NULL; } }

#define FALSE 0

#define TRUE 1

#define V4L2_CID_SWITCH_TABLE (V4L2_CID_BASE + 201 )

#define REAL_TIME 0x00000000  // 1 chip -> 1 channel  D1:30fps CIF: 30fps
#define SPLIT_2   0x00111111  // 1 chip -> 2 channel  D1:10fps CIF: 15fps
#define SPLIT_4   0x001B1B1B  // 1 chip -> 4 channel  D1: 5fps CIF:7.5fps

//#define DEFAULT_VIDEO_STANDARD V4L2_STD_NTSC_M // V4L2_STD_NTSC_M / V4L2_STD_PAL_B
#define DEFAULT_VIDEO_STANDARD V4L2_STD_PAL_B // V4L2_STD_NTSC_M / V4L2_STD_PAL_B

// In Split mode = 2, see CH2 image (default is CH1)
//#define SUBCH2

typedef struct CXWindow {

	Display *			m_pDisplay;				// XWINDOW
	ULONG				m_nDisplayScreen;		// XWINDOW
	ULONG				m_nDisplayWidth;		// XWINDOW
	ULONG				m_nDisplayHeight;		// XWINDOW
	ULONG				m_nDisplayDepth;		// XWINDOW
	Window				m_hWindow;				// XWINDOW
	XvPortID			m_nXvAdaptorPortID;		// XVIDEO.EXTENSION
	XvImage *			m_pXvImage;				// XVIDEO.EXTENSION
	BYTE *				m_pXvImageBuffer;		// XVIDEO.EXTENSION
	ULONG				m_nXvImageColorSpace;	// XVIDEO.EXTENSION
	ULONG				m_nXvImageWidth;		// XVIDEO.EXTENSION
	ULONG				m_nXvImageHeight;		// XVIDEO.EXTENSION
	ULONG				m_nXvImageDepth;		// XVIDEO.EXTENSION

} CXWindow;

typedef struct CVideoBuffer {

	VOID *				m_pKsBuffer;			// V4L2
	ULONG				m_nKsBufferSize;		// V4L2

} CVideoBuffer;

typedef struct CDevice {

	CXWindow *			m_pXWindow;				// V4L2
	int					m_hHwDevice;			// V4L2
	CVideoBuffer *		m_sVideoBuffer;			// V4L2
	ULONG				m_nVideoBufferSize;		// V4L2

} CDevice;

#endif
